package com.ekingwin.bas.cloud.protal.web;

import com.ekingwin.bas.cloud.protal.service.IProcessManagementService;
import com.ekingwin.bas.cloud.protal.vo.ProcessTraceVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/Process")
@Api(tags = "流程管理", description = "流程管理", value = "流程管理")
public class ProcessManagementController {

    @Autowired
    private IProcessManagementService processManagementService;

    @PostMapping(value = "/queryProcessTrace")
    @ApiOperation(value = "流程商品审核状态查询", notes = "流程商品审核状态查询")
    public Result queryProcessTrace(@RequestBody ProcessTraceVo processTraceVo) throws Exception{
        PageInfo pageInfo = processManagementService.queryProcessTrace(processTraceVo);
        return  Result.ok(pageInfo);
    }
}
