package com.ekingwin.bas.cloud.rabbit.receiver;

import com.ekingwin.bas.cloud.dto.IpGoodsStockDto;
import com.ekingwin.bas.cloud.service.IpGoodsService;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-24 17:43
 **/
@Component
@RabbitListener(bindings = @QueueBinding(
        value = @Queue(value = "${rabbitmq.receiver.goods}", autoDelete = "true"),
        exchange = @Exchange(value = "${rabbitmq.exchange.goods}", type = ExchangeTypes.TOPIC),
        key = "*.goods.stock"
))
public class GoodsStockReceiver {

    Logger logger = LoggerFactory.getLogger(GoodsStockReceiver.class);

    @Autowired
    private IpGoodsService ipGoodsService;

    @RabbitHandler
    public void deductionGoods(String msg) throws Exception{
        try{
            logger.info("扣减库存："+msg);
            JSONObject jsonObject=JSONObject.fromObject(msg);
            IpGoodsStockDto stockDto = (IpGoodsStockDto)JSONObject.toBean(jsonObject, IpGoodsStockDto.class);
            ipGoodsService.deductionGoodsStock(stockDto);
        }catch (Exception e){
            e.printStackTrace();
        }

    }
}
