package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.GoodsAddDto;
import com.ekingwin.bas.cloud.dto.GoodsDetailDto;
import com.ekingwin.bas.cloud.entity.IpGoodProcess;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.ekingwin.bas.cloud.vo.IpGoodsDetailVo;

import java.util.Map;

/**
 * The interface Ip goods draft service.
 *
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019 -07-09 09:59
 */
public interface IpGoodsDraftService {


    /**
     * 保存草稿数据
     *
     * @param goodsAddDto the goods add dto
     * @param goodsNum    the goods num
     * @param busskey     the busskey
     * @return long
     * @throws Exception the exception
     */
    Long saveGoodsProcess(GoodsAddDto goodsAddDto, String goodsNum,Long busskey) throws Exception;


    /**
     * 根据流程实例号获取数据
     *
     * @param instid the instid
     * @return goods process byinstid
     * @throws Exception the exception
     */
    GoodsDeatilVo getGoodsProcessByinstid(String instid) throws Exception;


    /**
     * 根据流程实例号获取流程数据
     *
     * @param instid the instid
     * @return good process
     * @throws Exception the exception
     */
    IpGoodProcess getGoodProcess(String instid) throws Exception;


    /**
     * 流程标题
     *
     * @param goodsname the goodsname
     * @param type      the type
     * @param goodsnum  the goodsnum
     * @return title
     */
    String getTitle(String goodsname,String type,String goodsnum);


    /**
     * 发起流程
     *
     * @param userId          the user id
     * @param title           the title
     * @param goodsProcessMap the goods process map
     * @return string
     * @throws Exception the exception
     */
    String startProcess(String userId,String title, Map<String, Object> goodsProcessMap) throws Exception;


    /**
     * 保存操作信息
     *
     * @param good    the good
     * @param type    the type
     * @param creteId the crete id
     * @param instid  the instid
     */
    public void saveGoodProcess(GoodsDetailDto good,
                                String type, String creteId, String instid);


    /**
     * 根据流程实例号获取商品详情
     *
     * @param instid the instid
     * @return goods detail by instid
     * @throws Exception the exception
     */
    IpGoodsDetailVo getGoodsDetailByInstid(String instid) throws Exception;


    /**
     * 根据流程实例号获取商品的类型
     *
     * @param instid the instid
     * @return the goods category
     * @Param: * @param instid
     * @return: java.lang.String
     * @Author: zhangjie
     * @Date: 2019 /11/9 14:32
     */
    String getGoodsCategory(String instid);
}
