package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.GoodsEvaluationAgainDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationPageDto;
import com.ekingwin.bas.cloud.entity.IpGoodsEvaluation;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;

/**
 * @ClassName: IpGoodsEvaluationService
 * @Author: liujunfeng
 * @Date: 2019/10/25 17:48
 * @description:
 */
public interface IpGoodsEvaluationService {

    /**
     * 新增商品评价
     * @param evaluationDto
     * @throws Exception
     */
    void saveGoodsEvaluation(IpGoodsEvaluationDto evaluationDto) throws Exception;

    /**
     * 查询商品评价
     * @param evaluationDto
     * @return
     */
    PageInfo<IpGoodsEvaluation> selectGoodsEvaluation(IpGoodsEvaluationPageDto evaluationDto);

    /**
     * 查询商品综合评分平均分
     * @param evaluationDto
     * @return
     */
    IpGoodsEvaluation selectGoodsComprehensiveScore(IpGoodsEvaluationPageDto evaluationDto);


    /**
     * 商品评价回复
     * @param evaluationAgain
     * @return
     */
    Result replyGoodsEvaluation(GoodsEvaluationAgainDto evaluationAgain);

    /**
     * 删除评价和回复
     * @param evaluationAgain
     * @return
     */
    Result deleteReplyAndEvaluation(GoodsEvaluationAgainDto evaluationAgain);
}
