package com.ekingwin.bas.cloud.service;

import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.vo.*;
import com.github.pagehelper.PageInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * The interface Ip goods service.
 */
public interface IpGoodsService {

    /**
     * 新增商品信息
     *
     * @param goodsAddDto the goods add dto
     * @return long
     * @throws Exception the exception
     */
    Long saveGoods(GoodsAddDto goodsAddDto) throws Exception;


    /**
     * 获取商品详情
     *
     * @param goodsGetDetailDto the goods get detail dto
     * @return goods detail
     * @throws Exception the exception
     */
    GoodsDeatilVo getGoodsDetail(GoodsGetDetailDto goodsGetDetailDto) throws  Exception;


    /**
     * 计算运费
     *
     * @param ipGoodsFreightDto the ip goods freight dto
     * @return goods freight
     */
    float getGoodsFreight(IpGoodsFreightDto ipGoodsFreightDto);


    /**
     * 修改商品1分类供应商信息
     *
     * @param goodsCategoryDto the goods category dto
     * @return
     * @throws Exception the exception
     */
    void updateGoodsCategory(GoodsCategoryDto goodsCategoryDto) throws Exception;


    /**
     * 商品操作
     *
     * @param boGoodUpDto the bo good up dto
     * @return boolean
     * @throws Exception the exception
     */
    boolean approvalGoods(BoGoodUpDto boGoodUpDto) throws Exception;


    /**
     * 流程审批通过
     *
     * @param ipGoodsProcessDto the ip goods process dto
     * @throws Exception the exception
     */
    void  initGoodsProcess(IpGoodsProcessDto ipGoodsProcessDto) throws  Exception;


    /**
     * 获取操作记录
     *
     * @param goodsGetDetailDto the goods get detail dto
     * @return goods logs
     */
    PageInfo getGoodsLogs(GoodsGetDetailDto goodsGetDetailDto);


    /**
     * 获取商品的价格
     *
     * @param priceDto the price dto
     * @return goods price
     * @throws Exception the exception
     */
    IpGoodPriceVo getGoodsPrice(IpGoodPriceDto priceDto) throws Exception;


    /**
     * 获取商品描述详情
     *
     * @param goodsGetDetailDto the goods get detail dto
     * @return goods details
     * @throws Exception the exception
     */
    IpGoodsDetailVo getGoodsDetails(GoodsGetDetailDto goodsGetDetailDto) throws Exception;


    /**
     * 文件导出
     *
     * @param goodsId   the goods id
     * @param response  the response
     * @param goodsname the goodsname
     * @throws Exception the exception
     */
    void exportExcel(String goodsId, HttpServletResponse response,String goodsname)throws Exception;


    /**
     * 商品导入
     *
     * @param file         the file
     * @param userId       the user id
     * @param categoryType the category type
     * @return the goods import vo
     * @throws Exception the exception
     */
    GoodsImportVo importGoods(MultipartFile file,String userId,String categoryType) throws Exception;


    /**
     * 商品库
     *
     * @param messageCategoryDto the message category dto
     * @return the goods message
     * @Param: * @param messageCategoryDto
     * @return: com.ekingwin.bas.cloud.vo.GoodsMessageVo
     * @Author: zhangjie
     * @Date: 2019 /10/21 22:34
     */
    GoodsMessageVo getGoodsMessage(GoodsMessageCategoryDto messageCategoryDto);


    /**
     * 商品复制
     *
     * @param copyGoodsDto the copy goods dto
     * @throws Exception the exception
     * @Param: * @param copyGoodsDto
     * @return: void
     * @Author: zhangjie
     * @Date: 2019 /10/22 20:58
     */
    void copyGoods(CopyGoodsDto copyGoodsDto) throws Exception;


    /**
     * 扣减库存
     *
     * @param ipGoodsStockDto the ip goods stock dto
     * @throws Exception the exception
     * @Param: * @param ipGoodsStockDto
     * @return: void
     * @Author: zhangjie
     * @Date: 2019 /11/2 15:56
     */
    void deductionGoodsStock(IpGoodsStockDto ipGoodsStockDto) throws Exception;


    /**
     * 获取规格型号
     *
     * @param goodsSpecificationDto the goods specification dto
     * @return goods specification
     * @throws Exception the exception
     */
    GoodsSpecificationVo getGoodsSpecification(GoodsSpecificationDto goodsSpecificationDto) throws Exception;


    /**
     * 同步sap商品数据
     *
     * @param type      the type
     * @param goodsId   the goods id
     * @param goodsType the goods type
     * @throws Exception the exception
     */
    void initGoodsSapId(String type, String goodsId,String goodsType) throws Exception;
}
