package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dto.CreateProcessDto;
import com.ekingwin.bas.cloud.handler.BusinessException;
import com.ekingwin.bas.cloud.service.BpmProcessService;
import com.ekingwin.bas.cloud.util.HttpXmlClient;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-07-08 21:56
 **/
@Service
@Primary
public class BpmProcessServiceImpl  implements BpmProcessService {


    @Value("${bpm.createProcessUrl}")
    private String createProcessUrl;

    @Value("${bpm.sysId}")
    private String sysId;
    @Value("${bpm.sign}")
    private String sign;



    @Override
    public String createProcess(CreateProcessDto createProcessDto) throws Exception {
        createProcessDto.setSign(sign);
        createProcessDto.setSysId(sysId);
        JSONObject jsonResult = JSONObject.fromObject(createProcessDto);
        String result =  HttpXmlClient.post1(jsonResult.toString(),createProcessUrl);
        JSONObject jsonObject=JSONObject.fromObject(result);
        Integer status =Integer.parseInt(jsonObject.get("code").toString());
        if(status==200){
            String instanceId = (String) jsonObject.get("data");
            return  instanceId;
        }else {
            throw  new BusinessException(500,jsonObject.get("msg").toString());
        }
    }

}
