package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodFootMapper;
import com.ekingwin.bas.cloud.dto.GoodsGetDetailDto;
import com.ekingwin.bas.cloud.dto.IpGoodFootDto;
import com.ekingwin.bas.cloud.dto.IpGoodFootSearchDto;
import com.ekingwin.bas.cloud.service.IpGoodFootService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.ekingwin.bas.cloud.vo.GoodsSupplierInfoVo;
import com.ekingwin.bas.cloud.vo.IpGoodFootSearchVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-08-08 14:54
 **/
@Service
@Primary
public class IpGoodFootServiceImpl implements IpGoodFootService {


    @Autowired
    private IpGoodFootMapper ipGoodFootMapper;

    @Value("${goods.baseurl}")
    private String baseurl;
    /**
     * 查询浏览足迹
     * @param ipGoodFootSearchDto
     * @return
     */
    @Override
    public PageInfo<IpGoodFootSearchVo> getGoodsFoot(IpGoodFootSearchDto ipGoodFootSearchDto){

        ipGoodFootSearchDto.setGoodsPath(baseurl);
        PageHelper.startPage(ipGoodFootSearchDto.getPagenum(),ipGoodFootSearchDto.getPagesize());
        List<IpGoodFootSearchVo> goodFootMapperGoodFoot =ipGoodFootMapper.getGoodFoot(ipGoodFootSearchDto);
        PageInfo<IpGoodFootSearchVo>  pageInfo=new PageInfo<>(goodFootMapperGoodFoot);
        return  pageInfo;
    }


    /**
     *  保存浏览足迹
     * @param goodsDeatilVo
     * @param goodsGetDetailDto
     */
    @Override
    @Async
    public void saveGoodsFoot(GoodsDeatilVo goodsDeatilVo,GoodsGetDetailDto goodsGetDetailDto){

        IpGoodFootDto ipGoodFootDto=new IpGoodFootDto();
        ipGoodFootDto.setGoodsid(goodsGetDetailDto.getGoodsId());
        ipGoodFootDto.setCompanyId(goodsGetDetailDto.getCompanyId());
        ipGoodFootDto.setUserid(goodsGetDetailDto.getUserid());
        GoodsSupplierInfoVo supplierInfo = goodsDeatilVo.getSupplierInfo();
        Map<String, Object> goodsMap = goodsDeatilVo.getGoodsMap();
        //获取图片的地址
        if (goodsMap !=null){
           if (StringUtils.isNotEmpty(goodsMap.get("urlid"))){
               String urlid=goodsMap.get("urlid").toString();
               ipGoodFootDto.setGoodsurlid(urlid);
           }
        }
        if (supplierInfo !=null){
            ipGoodFootDto.setSuppliernum(supplierInfo.getSuppliernum());
        }
        int footByGoodsId = ipGoodFootMapper.getFootByGoodsId(ipGoodFootDto);
        if (footByGoodsId>0){
            ipGoodFootMapper.updateFootTime(ipGoodFootDto);
        }else{
            ipGoodFootMapper.insertSelective(ipGoodFootDto);
        }
    }

}
