package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.*;
import com.ekingwin.bas.cloud.dto.*;
import com.ekingwin.bas.cloud.entity.*;
import com.ekingwin.bas.cloud.service.IpGoodsDraftService;
import com.ekingwin.bas.cloud.util.DateUtils;
import com.ekingwin.bas.cloud.util.MapObjUtil;
import com.ekingwin.bas.cloud.util.ReadTxtUtil;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.GoodsDeatilVo;
import com.ekingwin.bas.cloud.vo.IpGoodsDetailVo;
import com.ekingwin.bas.cloud.vo.IpGoodsPriceVo;
import com.ekingwin.bas.cloud.vo.IpGoodsSuppliersVo;
import org.apache.logging.log4j.core.util.UuidUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * The type Ip goods draft service.
 *保存商品草稿数据
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019 -07-11 19:31
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpGoodsDraftServiceImpl  implements IpGoodsDraftService {


    @Autowired
    private IpGoodProcessMapper ipGoodProcessMapper;

    @Autowired
    private IpGoodsDraftMapper ipGoodsDraftMapper;

    @Autowired
    private IpGoodsSuppliersProcessMapper ipGoodsSuppliersProcessMapper;


    @Autowired
    private IpGoodsSupplierFreightProcessMapper ipGoodsSupplierFreightProcessMapper;


    @Autowired
    private IpGoodsPriceProcessMapper ipGoodsPriceProcessMapper;

    @Autowired
    private IpGoodsImgProcessMapper ipGoodsImgProcessMapper;


    @Autowired
    private BpmProcessServiceImpl bpmProcessService;

    @Value("${goods.detailurl}")
    private String filePath;

    @Value("${goods.baseurl}")
    private String baseurl;

    /**
     * 保存草稿数据
     * @param goodsAddDto
     * @return
     * @throws Exception
     */
    @Override
    public Long saveGoodsProcess(GoodsAddDto goodsAddDto,
                                 String goodsNum,Long goodsId) throws Exception{


        Integer status=goodsAddDto.getStatus();
        if (status.equals(1) && StringUtils.isEmpty(goodsAddDto.getInstid())){
            Long busskey=this.saveOrUpdateProcess(goodsAddDto,goodsNum,goodsId);

            //保存业务主键
            this.saveOrUpdateGoods(goodsAddDto,busskey);

            //保存商品价格信息
            this.saveOrUpdatePrice(busskey, goodsAddDto);

            //保存运费信息
            this.saveOrUpdateSupplierFreight(busskey, goodsAddDto);

            //保存商品图片
            this.saveOrUpdateFile(busskey, goodsAddDto);

            if (StringUtils.isEmpty(goodsAddDto.getInstid()) && status.equals(1)){
                Map<String, Object> goodsMap = goodsAddDto.getGoodsMap();
                String goodsName=goodsMap.get("name").toString();
                String title=this.getTitle(goodsName,goodsAddDto.getType(),goodsNum);
                String instid=null;//this.startProcess(goodsAddDto.getUserid(),title);
                ipGoodProcessMapper.updateInstid(instid,busskey);
            }
        }else if (StringUtils.isNotEmpty(goodsAddDto.getInstid())){
            Long busskey=this.saveOrUpdateProcess(goodsAddDto,goodsNum,goodsId);

            //保存业务主键
            this.saveOrUpdateGoods(goodsAddDto,busskey);

            //保存商品价格信息
            this.saveOrUpdatePrice(busskey, goodsAddDto);

            //保存运费信息
            this.saveOrUpdateSupplierFreight(busskey, goodsAddDto);

            //保存商品图片
            this.saveOrUpdateFile(busskey, goodsAddDto);
        }

        return goodsId;
    }

    /**
     * 拼接流程标题
     * @param goodsname
     * @param type
     * @param goodsnum
     * @return
     */
    @Override
    public String getTitle(String goodsname,String type,String goodsnum){
        StringBuilder stringBuilder=new StringBuilder();
        stringBuilder.append(type);
        stringBuilder.append("-");
        stringBuilder.append(goodsname);
        stringBuilder.append("（");
        stringBuilder.append(goodsnum);
        stringBuilder.append(")");
        return  stringBuilder.toString();
    }

    /**
     * 保存流程草稿数据
     * @param goodsAddDto
     * @return
     */
    private Long saveOrUpdateProcess(GoodsAddDto goodsAddDto,String goodsNum,Long goodsId){

        Long busskey=null;
        if (StringUtils.isEmpty(goodsAddDto.getInstid())){
           // if (StringUtils.isEmpty(goodsAddDto.getGoodsId())){
                //先保存商品实例表数据
                IpGoodProcess ipGoodProcess=new IpGoodProcess();
                ipGoodProcess.setGoodsid(goodsId);
                ipGoodProcess.setType(goodsAddDto.getType());
                ipGoodProcess.setGoodsnum(goodsNum);
                ipGoodProcess.setCreateId(goodsAddDto.getUserid());
                //保存数据
                ipGoodProcessMapper.insertSelective(ipGoodProcess);
                busskey=ipGoodProcess.getId();
          //  }
        }else {
            IpGoodProcess ipGoodsProcessEntity=ipGoodProcessMapper.getGoodsProcessByinstid(goodsAddDto.getInstid());
            busskey=ipGoodsProcessEntity.getId();
        }


        return busskey;
    }


    /**
     * 保存流程
     * @param good
     * @param type
     * @param creteId
     * @param instid
     */
    @Override
    public void saveGoodProcess(GoodsDetailDto good,
                                String type,String creteId,String instid){
        IpGoodProcess ipGoodProcess=new IpGoodProcess();
        ipGoodProcess.setGoodsid(Long.parseLong(good.getGoodsid()));
        ipGoodProcess.setType(type);
        ipGoodProcess.setGoodsnum(good.getGoodsnum());
        ipGoodProcess.setCreateId(creteId);
        ipGoodProcess.setInstid(instid);
       //保存数据
        ipGoodProcessMapper.insertSelective(ipGoodProcess);
    }

    /**
     * 保存商品主表信息
     *
     * @param goodsAddDto
     * @return
     */
    private void saveOrUpdateGoods(GoodsAddDto goodsAddDto,Long proecssId) {

        /**
         * 删除主数据
         */
        ipGoodsDraftMapper.deleteGoodsProcess(proecssId);

        String detailFile = "";
        if (StringUtils.isNotEmpty(goodsAddDto.getDetails())) {
            //保存附件信息
            detailFile = "/" + UuidUtil.getTimeBasedUuid() + ".txt";
            //将2商品描述写入文件
            ReadTxtUtil.writeFile(filePath + detailFile, goodsAddDto.getDetails());
        }

        String descriptionFile ="";
        //保存规格参数
        if (StringUtils.isNotEmpty(goodsAddDto.getDescription())){
            //保存附件信息
            descriptionFile = "/" + UuidUtil.getTimeBasedUuid() + ".txt";

            //将2商品描述写入文件
            ReadTxtUtil.writeFile(filePath + descriptionFile, goodsAddDto.getDescription());

        }
        //先保存主表信息
        InsertMap insertGoodsMap = new InsertMap();
        Map<String, Object> goodsMap = goodsAddDto.getGoodsMap();

        String allPrice = "0";
        if (StringUtils.isNotEmpty(goodsMap.get("allPrice"))) {
            allPrice = goodsMap.get("allPrice").toString();
        }
        goodsMap.put("details", detailFile);
        goodsMap.put("price", allPrice);
        goodsMap.put("description",descriptionFile);
        insertGoodsMap.setTableName(IpGoodsProcessEntity.TABLENAME);
        goodsMap.put("urlid", goodsAddDto.getUrlid());
        goodsMap.put("userid", goodsAddDto.getUserid());
        goodsMap.put("processid",proecssId);
        insertGoodsMap.setParams(goodsMap);
        goodsMap.put("inputdate", DateUtils.format(new Date(), DateUtils.DATE_TIME_PATTERN));
        ipGoodsDraftMapper.insertGoods(insertGoodsMap);
    }



    /**
     * 保存商品费用
     */
    private void saveOrUpdatePrice(Long busskey, GoodsAddDto goodsAddDto) throws Exception {
        ipGoodsPriceProcessMapper.deleteByGoodsid(busskey);
        List<IpGoodsPriceDto> ipGoodsPriceDtos = goodsAddDto.getPriceDtoList();
        if (ipGoodsPriceDtos != null && ipGoodsPriceDtos.size() > 0) {
            IpGoodsPriceProcess goodsPrice = null;
            for (IpGoodsPriceDto ipGoodsPriceDto : ipGoodsPriceDtos) {
                goodsPrice = new IpGoodsPriceProcess();
                MapObjUtil.copy(ipGoodsPriceDto, goodsPrice);
                goodsPrice.setGoodsId(busskey);
                goodsPrice.setId(null);
                ipGoodsPriceProcessMapper.insertSelective(goodsPrice);
            }
        }
    }


    /**
     * 保存供应商运费
     */
    private void saveOrUpdateSupplierFreight(Long busskey, GoodsAddDto goodsAddDto) throws Exception {
        ipGoodsSupplierFreightProcessMapper.deleteByGoodsId(busskey);

        ipGoodsSuppliersProcessMapper.deleteByGoodsId(busskey);
        //获取供应商信息
        List<IpGoodsSuppliersDto> suppliersDtoListList = goodsAddDto.getSupplierList();
        if (suppliersDtoListList != null && suppliersDtoListList.size() > 0) {
            IpGoodsSuppliersProcess ipGoodsSuppliers = null;
            for (IpGoodsSuppliersDto ipGoodsSuppliersDto : suppliersDtoListList) {
                ipGoodsSuppliers = new IpGoodsSuppliersProcess();
                MapObjUtil.copy(ipGoodsSuppliersDto, ipGoodsSuppliers);
                ipGoodsSuppliers.setGoodsId(busskey);
                ipGoodsSuppliersProcessMapper.insertSelective(ipGoodsSuppliers);
                Long suppliersId = ipGoodsSuppliers.getId();
                //获取供应商运费信息
                List<IpGoodsSupplierFreightDto> ipGoodsPriceDtos = ipGoodsSuppliersDto.getSupplierFreightList();
                if (ipGoodsPriceDtos != null && ipGoodsPriceDtos.size() > 0) {
                    IpGoodsSupplierFreightProcess ipGoodsSupplierFreight = null;
                    for (IpGoodsSupplierFreightDto ipGoodsSupplierFreightDto : ipGoodsPriceDtos) {
                        ipGoodsSupplierFreight = new IpGoodsSupplierFreightProcess();
                        MapObjUtil.copy(ipGoodsSupplierFreightDto, ipGoodsSupplierFreight);
                        ipGoodsSupplierFreight.setGoodsId(busskey);
                        ipGoodsSupplierFreight.setGoodsSuppliersId(suppliersId);
                        ipGoodsSupplierFreightProcessMapper.insertSelective(ipGoodsSupplierFreight);
                    }
                }
            }
        }
    }

    /**
     * 保存商品图片
     *
     * @param busskey
     * @param goodsAddDto
     */
    private void saveOrUpdateFile(Long busskey, GoodsAddDto goodsAddDto) {
        ipGoodsImgProcessMapper.deleteByGoodsId(busskey);
        if (StringUtils.isNotEmpty(goodsAddDto.getUrlid())) {
            IpGoodsImgProcess ipGoodsImg = new IpGoodsImgProcess();
            ipGoodsImg.setGoodsid(busskey);
            ipGoodsImg.setGoodsimgid(goodsAddDto.getUrlid());
            ipGoodsImgProcessMapper.insertSelective(ipGoodsImg);
        }
    }


    /**
     * 流程发起
     * @return
     * @throws Exception
     */
    @Override
    public String startProcess(String userId,String title, Map<String, Object> goodsProcessMap) throws Exception {
        CreateProcessDto createProcessDto = new CreateProcessDto();
        createProcessDto.setProcessName("SPSXJLC");
        createProcessDto.setUserId(userId);
        createProcessDto.setSubject(title);
        createProcessDto.setBusinessData(goodsProcessMap);

        String instid = bpmProcessService.createProcess(createProcessDto);
        return instid;
    }


    /**
     * 根据流程实例号获取流程实例
     * @return
     */
    @Override
    public IpGoodProcess getGoodProcess(String instid) throws Exception{
        IpGoodProcess ipGoodProcess =ipGoodProcessMapper.getGoodsProcessByinstid(instid);
        return ipGoodProcess;
    }

    /**
     * 获取商品描述
     * @param instid
     * @return
     * @throws Exception
     */
    @Override
    public IpGoodsDetailVo getGoodsDetailByInstid(String instid) throws Exception{
        IpGoodProcess ipGoodProcess =this.getGoodProcess(instid);
        IpGoodsDetailVo ipGoodsDetailVo=null;
        Map<String, Object> map = ipGoodsDraftMapper.getGoodsDetail(ipGoodProcess.getId());
        if (map !=null){
            ipGoodsDetailVo=new IpGoodsDetailVo();
            String detailPath = map.get("details").toString();
            //获取商品1详情
            String detail = ReadTxtUtil.readFile1(filePath + detailPath);
            ipGoodsDetailVo.setDetail(detail);
        }
        return  ipGoodsDetailVo;
    }


    /**
     * 根据流程实例号获取数据
     * @param instid
     * @return
     * @throws Exception
     */
    @Override
    public GoodsDeatilVo getGoodsProcessByinstid(String instid) throws Exception{
        IpGoodProcess ipGoodProcess =this.getGoodProcess(instid);

        GoodsDeatilVo goodsDeatilVo = null;

        Map<String, Object> map = ipGoodsDraftMapper.getGoodsDetail(ipGoodProcess.getId());
        if (map !=null){
            goodsDeatilVo=new GoodsDeatilVo();
            Long goodId=ipGoodProcess.getId();
            //获取商品详情
            if (StringUtils.isNotEmpty(map.get("details"))){
                String detailPath = map.get("details").toString();
                //获取商品1详情
                String detail= ReadTxtUtil.readFile(filePath + detailPath);
                goodsDeatilVo.setDetails(detail);
            }


            //获取规格参数
            if (StringUtils.isNotEmpty(map.get("description"))){
                String descriptionPath = map.get("description").toString();
                //获取规格参数
                String  description= ReadTxtUtil.readFile(filePath + descriptionPath);
                goodsDeatilVo.setDescription(description);
            }
            goodsDeatilVo.setGoodsMap(map);

            //获取图片
            IpGoodsImgProcess ipGoodsImg = ipGoodsImgProcessMapper.selectByGoodsid(goodId);
            goodsDeatilVo.setUrlid(ipGoodsImg.getGoodsimgid());

            //获取图片path
            List<String> urlPath = ipGoodsImgProcessMapper.selectImgPath(goodId);
            List<String> utlPathList = new ArrayList<String>();
            if (urlPath != null && urlPath.size() > 0) {
                for (String s : urlPath) {
                    utlPathList.add(baseurl + s);
                }
            }
            goodsDeatilVo.setUrlpath(utlPathList);

            /**
             * 获取商品价格
             */
            goodsDeatilVo.setPriceList(this.getAllGoodsPrice(goodId));

            /**
             * 获取运费信息
             */
            goodsDeatilVo.setSuppliersList(this.getAllGoodsSupplier(goodId));
            goodsDeatilVo.setGoodsId(ipGoodProcess.getGoodsid());
        }
        return goodsDeatilVo;
    }


    /**
     * 获取商品价格
     *
     * @param goodId
     * @return
     * @throws Exception
     */
    private List<IpGoodsPriceVo> getAllGoodsPrice(Long goodId) throws Exception {
        List<IpGoodsPriceProcess> ipGoodsPrices = ipGoodsPriceProcessMapper.getDetailByGoodsid(goodId);
        List<IpGoodsPriceVo> ipGoodsPriceVoList = new ArrayList<IpGoodsPriceVo>();
        if (ipGoodsPrices != null && ipGoodsPrices.size() > 0) {
            IpGoodsPriceVo ipGoodsPriceVo = null;
            for (IpGoodsPriceProcess goodsPrice : ipGoodsPrices) {
                ipGoodsPriceVo = new IpGoodsPriceVo();
                MapObjUtil.copy(goodsPrice, ipGoodsPriceVo);
                ipGoodsPriceVoList.add(ipGoodsPriceVo);
            }
        }
        return ipGoodsPriceVoList;
    }


    /**
     * 获取商品运费
     *
     * @param goodId
     * @return
     * @throws Exception
     */
    private List<IpGoodsSuppliersVo> getAllGoodsSupplier(Long goodId) throws Exception {
        List<IpGoodsSuppliersVo> ipGoodsPrices = ipGoodsSuppliersProcessMapper.selectByGoodsId(goodId);
        return ipGoodsPrices;
    }

    /**
    * 获取分类信息
    * @Param:  * @param instid
    * @return: java.lang.String
    * @Author: zhangjie
    * @Date: 2019/11/9 14:30
    */
    @Override
    public String getGoodsCategory(String instid){
        String goodsCategory = ipGoodProcessMapper.getGoodsCategory(instid);
        return  goodsCategory;
    }
}
