package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodsEvaluationMapper;
import com.ekingwin.bas.cloud.dto.GoodsEvaluationAgainDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationPageDto;
import com.ekingwin.bas.cloud.entity.IpGoodsEvaluation;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.service.IpGoodsEvaluationService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName: IpGoodsEvaluationServiceImpl
 * @Author: liujunfeng
 * @Date: 2019/10/25 17:48
 * @description:
 */
@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpGoodsEvaluationServiceImpl extends BaseService implements IpGoodsEvaluationService {

    @Autowired
    IpGoodsEvaluationMapper evaluationMapper;

    /**
     * 新增商品评价
     *
     * @param evaluationDto
     * @throws Exception
     */
    @Override
    public void saveGoodsEvaluation(IpGoodsEvaluationDto evaluationDto) throws Exception {
        IpGoodsEvaluation evaluation = new IpGoodsEvaluation();
        this.commonBuild(evaluation, evaluationDto);
        if ("Y".equals(evaluationDto.getAdditional())) {
            //添加追评
            evaluation.setPid(evaluationDto.getAdditionalId());
            evaluation.setGoodsName("追评测试");
        } else {
            evaluation.setPid(0);
            evaluation.setEvaluationDate(new Date());
            Map<String, Object> map = new HashMap<>();
            map.put("id", evaluationDto.getOrdergoodsId());
            map.put("isevaluate", "Y");
            evaluationMapper.updateOrderAllGoods(map);
        }
        evaluationMapper.saveGoodsEvaluation(evaluation);
    }

    /**
     * 查询商品评价
     *
     * @param evaluationDto
     * @return
     */
    @Override
    public PageInfo<IpGoodsEvaluation> selectGoodsEvaluation(IpGoodsEvaluationPageDto evaluationDto) {
        PageHelper.startPage(evaluationDto.getPagenum(), evaluationDto.getPagesize());
        List<IpGoodsEvaluation> evaluationList = null;
        //查询当前用户的权限问题
        Integer jurisdiction = evaluationMapper.queryJurisdiction(evaluationDto.getEvaluationId());
        if (jurisdiction > 0) {
            //查询个数大于0，有权限，可以查看所有评论
            evaluationList = evaluationMapper.selectGoodsEvaluation(evaluationDto.getGoodsId());
        } else {
            //查询个数小于0，无权限，可以查看自己评论
            evaluationList = evaluationMapper.selectMyEvaluation(evaluationDto.getGoodsId(), evaluationDto.getEvaluationId());
        }
        for (int i = 0; i < evaluationList.size(); i++) {
            //查询回复信息
            List<GoodsEvaluationAgainDto> evaluationAgain = evaluationMapper.selectreply(evaluationList.get(i).getId());
            evaluationList.get(i).setEvaluationAgain(evaluationAgain);
        }

        PageInfo pageInfo = new PageInfo<>(evaluationList);
        return pageInfo;
    }


    /**
     * 查询商品综合评分平均分
     *
     * @param evaluationDto
     * @return
     */
    @Override
    public IpGoodsEvaluation selectGoodsComprehensiveScore(IpGoodsEvaluationPageDto evaluationDto) {
        IpGoodsEvaluation goodsEvaluation = evaluationMapper.selectGoodsComprehensiveScore(evaluationDto.getGoodsId());
        return goodsEvaluation;
    }

    /**
     * 商品评价回复
     *
     * @param evaluationAgain
     * @return
     */
    @Override
    public Result replyGoodsEvaluation(GoodsEvaluationAgainDto evaluationAgain) {
        //查询当前用户的权限问题
        Integer jurisdiction = evaluationMapper.queryJurisdiction(evaluationAgain.getEvaluationId());
        if (jurisdiction > 0) {
            try {
                String time = null;
                Date date = new Date();
                SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                time = d.format(date);
                evaluationAgain.setEvaluationDate(time);
                //查询个数大于0，有权限，可以回复评价信息
                evaluationMapper.addReplyGoodsEvaluation(evaluationAgain);
                return Result.ok("回复成功");
            } catch (Exception e) {
                e.printStackTrace();
                return Result.ok("回复操作失败");
            }
        } else {
            //查询个数小于0，无权限，不可回复
            return Result.error("您无权限回复");
        }
    }

    /**
     * 删除评价和回复
     *
     * @param evaluationAgain
     * @return
     */
    @Override
    public Result deleteReplyAndEvaluation(GoodsEvaluationAgainDto evaluationAgain) {
        //查询当前用户的权限问题
        Integer jurisdiction = evaluationMapper.queryJurisdiction(evaluationAgain.getEvaluationId());
        if (jurisdiction > 0) {
            try {
                //查询个数大于0，有权限，可以所有评论都有权限删除
                evaluationMapper.deleteEvaluation(evaluationAgain);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("删除评论失败");
            }
        } else {
            try {
                //查询个数小于0，无权限，可以删除自己评论
                evaluationMapper.deleteMyEvaluation(evaluationAgain);
            } catch (Exception e) {
                e.printStackTrace();
                return Result.error("本次删除操作失败");
            }
        }
        try {
            //所有评价对应的回复信息都有权限删除
            evaluationMapper.deleteReply(evaluationAgain);
        } catch (Exception e) {
            e.printStackTrace();
            return Result.error("删除回复失败");
        }
        return Result.ok("删除成功");
    }
}
