package com.ekingwin.bas.cloud.service.impl;

import com.ekingwin.bas.cloud.dao.IpGoodsManageMapper;
import com.ekingwin.bas.cloud.dao.IpSapGoodsDtoMapper;
import com.ekingwin.bas.cloud.infra.service.BaseService;
import com.ekingwin.bas.cloud.rabbit.sender.SapGoodsSender;
import com.ekingwin.bas.cloud.service.IpGoodsSapService;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.ekingwin.bas.cloud.vo.*;
import net.sf.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.util.*;

@Service
@Primary
@Transactional(rollbackFor = Exception.class)
public class IpGoodsSapServiceImpl extends BaseService implements IpGoodsSapService {

    private Logger logger = LoggerFactory.getLogger(IpGoodsSapServiceImpl.class);

    @Autowired
    private IpGoodsManageMapper ipGoodsManageMapper;

    @Autowired
    private IpSapGoodsDtoMapper ipSapGoodsDtoMapper;

    @Autowired
    private SapGoodsSender sapGoodsSender;

    @Override
    public IpGoodsManageVo getGoodsManage(String goodsId) {
        IpGoodsManageVo ipGoodsManageVo = null;
        if (StringUtils.isNotEmpty(goodsId)) {
            List<IpGoodsManageVo> goodsManage = ipGoodsManageMapper.getGoodsManage(goodsId);
            if (goodsManage != null && goodsManage.size() > 0) {
                ipGoodsManageVo = goodsManage.get(0);
            }
        }
        return ipGoodsManageVo;
    }

    /**
     * @param goodsId
     * @return
     */
    @Override
    public List<IpGoodsSapPriceVo> getGoodsPrice(String goodsId) {
        List<IpGoodsSapPriceVo> goodsPrice = ipGoodsManageMapper.getGoodsPrice(goodsId);
        return goodsPrice;
    }

    /**
     * @param categoryId
     * @return
     */
    @Override
    public List<IpGoodsManageSuppliersVo> getGoodsManageSupplier(String categoryId) {
        List<IpGoodsManageSuppliersVo> goodsManageSupplier = ipGoodsManageMapper.getGoodsManageSupplier(categoryId);
        return goodsManageSupplier;
    }

    @Override
    public void initGoodsDetailList(List<IpGoodsManagesVo> goodsManagesVos) throws Exception {
        Runnable runnable = ()-> {
            try {
                boolean flag=true;
                List<IpGoodsTypeVo> goodsTypeVos = new ArrayList<>();
                for (IpGoodsManagesVo goodsManagesVo : goodsManagesVos) {
                    IpGoodsTypeVo goodsDetail = this.getGoodsDetail(goodsManagesVo);
                    if (StringUtils.isEmpty(goodsDetail.getContractId())){
                        flag=false;
                        break;
                    }
                    goodsTypeVos.add(goodsDetail);
                }
                if (flag){
                    String string = JSONArray.fromObject(goodsTypeVos).toString();
                    logger.info("同步sap材料明细："+string);
                    sapGoodsSender.send("send.sapgoods.info", string);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        };
        new Thread(runnable).start();
    }


    private IpGoodsTypeVo getGoodsDetail(IpGoodsManagesVo ipGoodsManagesVo
    ) throws Exception {
        IpGoodsTypeVo ipGoodsTypeVo = new IpGoodsTypeVo();
        IpGoodsManageVo xgoodsManageVo = ipGoodsManagesVo.getXgoodsManageVo();
        String contractId = xgoodsManageVo.getContractId();
        String goodsId = xgoodsManageVo.getGoodsId();
        List<IpGoodsSapPriceVo> xgoodsPrice = ipGoodsManagesVo.getXgoodsPrice();
        String intfType = ipGoodsManagesVo.getIntfType();
        ipGoodsTypeVo.setIntfType(intfType);
        ipGoodsTypeVo.setContractId(xgoodsManageVo.getContractId());
        List<IpGoodsManageSapVo> ygoodsOManages = ipSapGoodsDtoMapper.selectByGoodsId(goodsId);
        List<IpGoodsManageSapVo> xgoodsOManages=null;
        if (xgoodsPrice !=null && xgoodsPrice.size()>0){
            xgoodsOManages = this.getGoodsOManages(xgoodsManageVo, xgoodsPrice);
        }

        List<IpGoodsManageSapVo> manageSapVos = this.initGoodsManagePrice(ygoodsOManages, xgoodsOManages);
        //保存商品同步sap记录
        if (manageSapVos != null && manageSapVos.size() > 0) {
            ipSapGoodsDtoMapper.insert(manageSapVos);
        }


        ipGoodsTypeVo.setProductInfos(manageSapVos);
        ipGoodsTypeVo.setContractId(contractId);
        List<IpGoodsManageSuppliersVo> suppliersVos = ipGoodsManagesVo.getSuppliersVos();
        ipGoodsTypeVo.setContVlistInfos(this.getManageSupplier(suppliersVos, contractId, goodsId));
        return ipGoodsTypeVo;
    }

    private List<IpGoodsManageSuppliersVo> getManageSupplier(List<IpGoodsManageSuppliersVo> goodsManageSupplier,
                                                             String contractId, String goodsId) {
        List<IpGoodsManageSuppliersVo> goodsManageSuppliersVos = new ArrayList<>();

        //原供应商
        List<IpGoodsManageSuppliersVo> suppliers = ipSapGoodsDtoMapper.getSuppliers(goodsId);

        if (goodsManageSupplier != null && goodsManageSupplier.size() > 0) {
            Set<String> suppliersSet=new HashSet<String>();
            for (IpGoodsManageSuppliersVo ipGoodsManageSuppliersVo : goodsManageSupplier) {
                String supplierCode = ipGoodsManageSuppliersVo.getSupplierCode();
                List<String> projectCode = this.getProjectCodeMain(ipGoodsManageSuppliersVo.getServiceRange());
                if (projectCode != null && projectCode.size() > 0) {
                    IpGoodsManageSuppliersVo goodsManageSuppliersVo = null;
                    for (String s : projectCode) {
                        Iterator<IpGoodsManageSuppliersVo> iterator = suppliers.iterator();
                        goodsManageSuppliersVo = new IpGoodsManageSuppliersVo();
                        goodsManageSuppliersVo.setContractId(contractId);
                        goodsManageSuppliersVo.setServiceRange(s);
                        goodsManageSuppliersVo.setSupplierCode(supplierCode);
                        goodsManageSuppliersVo.setGoodsId(goodsId);
                        boolean flag = false;
                        String goodsSuppliersStr=null;
                        goodsSuppliersStr=goodsId+"--"+supplierCode+"--"+s;

                        while (iterator.hasNext()) {
                            IpGoodsManageSuppliersVo next = iterator.next();
                            String supplierCode1 = next.getSupplierCode();
                            String serviceRange = next.getServiceRange();
                            if (supplierCode1.equals(supplierCode) && serviceRange.equals(s)) {
                                flag = this.compareContract(next, goodsManageSuppliersVo);
                                iterator.remove();
                                break;
                            }
                        }
                        if (!flag) {
                            if (!suppliersSet.contains(goodsSuppliersStr)){
                                goodsManageSuppliersVos.add(goodsManageSuppliersVo);
                                suppliersSet.add(goodsSuppliersStr);
                            }

                        }
                    }
                }
            }
        }
        if (suppliers != null && suppliers.size() > 0) {
            for (IpGoodsManageSuppliersVo supplier : suppliers) {
                supplier.setExtend6("X");
                goodsManageSuppliersVos.add(supplier);
            }
        }
        if (goodsManageSuppliersVos != null && goodsManageSuppliersVos.size() > 0) {
            ipSapGoodsDtoMapper.insertSupplier(goodsManageSuppliersVos);
        }
        return goodsManageSuppliersVos;
    }

    private List<IpGoodsManageSapVo> initGoodsManagePrice(List<IpGoodsManageSapVo> ygoodsOManages, List<IpGoodsManageSapVo> xgoodsOManages) {
        List<IpGoodsManageSapVo> manageSapVos = new ArrayList<>();
        HashSet<String> strings = new HashSet<>();
        if (xgoodsOManages !=null && xgoodsOManages.size()>0){
            for (IpGoodsManageSapVo xgoodsOManage : xgoodsOManages) {
                String projectCode = xgoodsOManage.getProjectCode();
                strings.add(projectCode);
                boolean goodsCz = false;
                if (ygoodsOManages != null && ygoodsOManages.size() > 0) {
                    for (IpGoodsManageSapVo ygoodsOManage : ygoodsOManages) {
                        String projectCode1 = ygoodsOManage.getProjectCode();
                        if (projectCode.equals(projectCode1)) {
                            boolean flag = this.compareContract(xgoodsOManage, ygoodsOManage);
                            if (flag) {
                                goodsCz = true;
                            } else {
                                goodsCz = false;
                            }
                            break;
                        }
                    }
                }

                //判断是否存在
                if (!goodsCz) {
                    manageSapVos.add(xgoodsOManage);
                }
            }
        }

        //标识删除的
        if (ygoodsOManages != null && ygoodsOManages.size() > 0) {
            for (IpGoodsManageSapVo ygoodsOManage : ygoodsOManages) {
                String projectCode1 = ygoodsOManage.getProjectCode();
                if (!strings.contains(projectCode1)) {
                    ygoodsOManage.setValid("X");
                    manageSapVos.add(ygoodsOManage);
                }
            }
        }
        return manageSapVos;
    }

    /**
     * 1.首选取到分类的销售区域
     * 2.在取到商品设置的价格销售区域
     * 3.取交集
     *
     * @param goodsManageVo
     * @return
     */
    private List<IpGoodsManageSapVo> getGoodsOManages(IpGoodsManageVo goodsManageVo, List<IpGoodsSapPriceVo> goodsPrice) throws Exception {
        List<IpGoodsManageSapVo> goodsManageVos = new ArrayList<>();
        String salesarea = goodsManageVo.getSalesarea();
        //获取商品的总销售的所有区域
        /*List<String> projectCode = this.getProjectCode(salesarea);*/
        //获取商品所在销售区域的价格
        for (IpGoodsSapPriceVo ipGoodsSapPriceVo : goodsPrice) {
            String hsprice = ipGoodsSapPriceVo.getHsprice();
            String noHsPrice = ipGoodsSapPriceVo.getNoHsPrice();
            String companyId = ipGoodsSapPriceVo.getCompanyId();
            //获取项目的价格
            List<String> projectCode1 = this.getProjectCodeMain(companyId);
            List<String> projectCode2 = new ArrayList<>();
            IpGoodsManageSapVo ipGoodsManageSapVo = null;
            for (String s : projectCode1) {
               /* if (projectCode.contains(s)) {*/
                    ipGoodsManageSapVo = new IpGoodsManageSapVo();
                    this.commonBuild(ipGoodsManageSapVo, goodsManageVo);
                    ipGoodsManageSapVo.setProjectCode(s);
                    ipGoodsManageSapVo.setCashPrice(hsprice);
                    ipGoodsManageSapVo.setTaxFreeCashPrice(noHsPrice);
                    goodsManageVos.add(ipGoodsManageSapVo);
                    projectCode2.add(s);
          /*      }*/
            }
        }

        return goodsManageVos;
    }
    private List<String> getProjectCodeMain(String salesarea){
        String[] split = salesarea.split(",");
        List<String> arrayList = null;
        if (split != null && split.length > 0) {
            HashSet<String> objects = new HashSet<String>();
            for (String s : split) {
                if (objects.contains(s)) {
                    continue;
                }
                objects.add(s);
            }
            arrayList = new ArrayList<String>(objects);
        }
        return arrayList;
    }


    private List<String> getProjectCode(String salesarea) {
        String[] split = salesarea.split(",");
        List<String> arrayList = null;
        if (split != null && split.length > 0) {
            HashSet<String> objects = new HashSet<String>();
            for (String s : split) {
                if (objects.contains(s)) {
                    continue;
                }
                HashSet<String> projectTreeCode = this.getProjectTreeCode(s);
                objects.addAll(projectTreeCode);
            }
            arrayList = new ArrayList<String>(objects);

            //拆分获取到项目
          /*  String join = String.join(",", list);
            arrayList = ipGoodsManageMapper.getProjectCode(join);*/
        }
        return arrayList;
    }

    private HashSet<String> getProjectTreeCode(String code) {
        String childCode = ipGoodsManageMapper.getChildCode(code);
        String[] split = childCode.split(",");
        List<String> strings = Arrays.asList(split);
        return new HashSet<>(strings);
    }

    private boolean compareContract(Object obj, Object obj2) {
        boolean flag = true;
        try {
            Field[] fields = getAllFields(obj);
            for (int j = 0; j < fields.length; j++) {
                fields[j].setAccessible(true);
                if (StringUtils.isEmpty(fields[j].get(obj)) && StringUtils.isNotEmpty(fields[j].get(obj2))) {
                    flag = false;
                    break;
                } else if (StringUtils.isNotEmpty(fields[j].get(obj)) && StringUtils.isEmpty(fields[j].get(obj2))) {
                    flag = false;
                    break;
                } else if (StringUtils.isEmpty(fields[j].get(obj)) && StringUtils.isEmpty(fields[j].get(obj2))) {

                } else {
                    // 字段值
                    if (!fields[j].get(obj).equals(fields[j].get(obj2))) {
                        flag = false;
                        break;
                    }
                }

            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return flag;
    }

    private static Field[] getAllFields(Object object) {
        Class clazz = object.getClass();
        List<Field> fieldList = new ArrayList<>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }
}
