package com.ekingwin.bas.cloud.supplier.service.impl;

import com.ekingwin.bas.cloud.infra.utils.web.WebUtils;
import com.ekingwin.bas.cloud.protal.dto.*;
import com.ekingwin.bas.cloud.protal.vo.*;
import com.ekingwin.bas.cloud.supplier.dao.SupplierTerDao;
import com.ekingwin.bas.cloud.supplier.dto.*;
import com.ekingwin.bas.cloud.supplier.service.SupplierTerService;
import com.ekingwin.bas.cloud.supplier.vo.ShipmnetsVo;
import com.ekingwin.bas.cloud.supplier.vo.SupGoodsVo;
import com.ekingwin.bas.cloud.supplier.vo.SupplierGoodsVo;
import com.ekingwin.bas.cloud.supplier.vo.SupplierVo;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.util.StringUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author kan
 * @version 1.0.0
 * @ClassName SupplierTerServiceImpl.java
 * @Description TODO
 * @createTime 2020/3/25 14:40
 */
@Service
@Primary
public class SupplierTerServiceImpl implements SupplierTerService {
    @Autowired
    private SupplierTerDao supplierTerDao;
    @Value("${baseurl}")
    private String baseurl;
    @Value("${dataSourceName}")
    private String twbusiness;
    @Value("${img.url}")
    private String url;
    @Value("${onTheAuditUrl}")
    private String onTheAuditUrl;

    @Override
    public PageInfo orderList(SupplierVo supplierVo) {
        PageHelper.startPage(supplierVo.getPagenum(), supplierVo.getCount());
        if (StringUtils.isEmpty(supplierVo.getSubject())) {
            supplierVo.setSubject("");
        }
        supplierVo.setBaseurl(baseurl);
        List<OrderDto> orderDtoList = supplierTerDao.orderList(supplierVo);
        if (orderDtoList != null && !orderDtoList.isEmpty()) {
            if (Integer.parseInt(orderDtoList.get(0).getSurfacetype()) == 1) {
                supplierVo.setSeq(orderDtoList.get(0).getSeq());
                List<AllGoodsDto> allGoodsDto = supplierTerDao.allGoodsList(supplierVo);
                if (allGoodsDto != null && !allGoodsDto.isEmpty()) {
                    for (int i = 0; i < allGoodsDto.size(); i++) {
                        BigInteger goodsid = allGoodsDto.get(i).getGoodsid();
                        BigIntString bisdto = new BigIntString();
                        bisdto.setGoodsid(goodsid);
                        bisdto.setTwbusiness(twbusiness);
                        bisdto.setBaseurl(baseurl);
                        SupplierGoodsDto2 supplierGoodsDto2 = new SupplierGoodsDto2();
                        List<SupplierGoodsDto2> GoodsList = supplierTerDao.getGoods(bisdto);
                        if (GoodsList != null && !GoodsList.isEmpty()) {
                            supplierGoodsDto2.setCandate(GoodsList.get(0).getCandate());
                            supplierGoodsDto2.setUrl(GoodsList.get(0).getUrl());
                            supplierGoodsDto2.setName(GoodsList.get(0).getName());
                            supplierGoodsDto2.setFTNPFirstCategoryCode(GoodsList.get(0).getFTNPFirstCategoryCode());
                            supplierGoodsDto2.setFTNPFirstCategoryName(GoodsList.get(0).getFTNPFirstCategoryName());
                            supplierGoodsDto2.setFTNPSpecificationsModel(GoodsList.get(0).getFTNPSpecificationsModel());
                            supplierGoodsDto2.setBrand(GoodsList.get(0).getBrand());
                            orderDtoList.get(0).setGoodslist(supplierGoodsDto2);
                        }
                    }
                }
            }
        }
        PageInfo pageInfo = new PageInfo<>(orderDtoList);
        return pageInfo;
    }

    @Override
    public Boolean sugoodsStateUpdate(ShipmnetsVo shipmnetsVo) {
        String goodsid = shipmnetsVo.getGoodsid();
        String ordernum = shipmnetsVo.getOrdernum();
        System.out.println(goodsid);
        System.out.println(ordernum);
        try {
            if (StringUtils.isNotEmpty(goodsid) && StringUtils.isNotEmpty(ordernum)) {
                String[] goodsids = goodsid.split(",");
                String[] ordernums = ordernum.split(",");
                for (int i = 0; i < goodsids.length; i++) {
                    shipmnetsVo.setGoodsid(goodsids[i]);
                    shipmnetsVo.setOrdernum(ordernums[i]);
                    String ordernum1 = ordernums[i];
                    supplierTerDao.sugoodsStateUpdate(shipmnetsVo);
                    supplierTerDao.sugoodsStateUpdate2(ordernum1);
                }
            }
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public PageInfo NoJdGoodsMessage(SupGoodsVo supGoodsVo) {
        PageHelper.startPage(supGoodsVo.getPageIndex(), supGoodsVo.getPageSize());
        supGoodsVo.setBaseurl(baseurl);
        List<GoodsSupplierDto> goodsSupplierList = new ArrayList<>();
        if (StringUtils.isEmpty(supGoodsVo.getCategoryid())) {
            goodsSupplierList = supplierTerDao.NoJdGoodsMessage(supGoodsVo);
            if (goodsSupplierList != null && !goodsSupplierList.isEmpty()) {
                for (int i = 0; i < goodsSupplierList.size(); i++) {
                    goodsSupplierList.get(i).setSupplier(goodsSupplierList.get(i).getFullname());
                }
            }
            PageInfo pageInfo = new PageInfo<>(goodsSupplierList);
            return pageInfo;
        } else {
            String categoryids = "";
            String categoryid = supGoodsVo.getCategoryid();
            String type = supplierTerDao.gettype(categoryid);
            if ("0".equals(type)) {
                String categoryidstmp = "";
                List<CategoryDto> categoryList = supplierTerDao.getCategoryDetail(categoryid);
                if (categoryList != null && !categoryList.isEmpty()) {
                    for (int i = 0; i < categoryList.size(); i++) {
                        categoryidstmp = categoryidstmp + categoryList.get(i).getId() + ",";
                    }
                    if (StringUtils.isNotEmpty(categoryidstmp)) {
                        categoryidstmp = categoryidstmp.substring(0, categoryidstmp.length() - 1);
                    }
                }
                List<CategoryDto> categoryList2 = supplierTerDao.getCategoryByPid(categoryidstmp);
                if (categoryList2 != null && !categoryList2.isEmpty()) {
                    for (int i = 0; i < categoryList2.size(); i++) {
                        categoryids = categoryids + categoryList2.get(i).getId() + ",";
                    }
                    if (StringUtils.isNotEmpty(categoryids)) {
                        categoryids = categoryids.substring(0, categoryids.length() - 1);
                    }
                }
                if (StringUtils.isNotEmpty(categoryids)) {
                    supGoodsVo.setCategoryid(categoryids);
                    goodsSupplierList = supplierTerDao.NoJdGoodsMessage2(supGoodsVo);
                    if (goodsSupplierList != null && !goodsSupplierList.isEmpty()) {
                        for (int i = 0; i < goodsSupplierList.size(); i++) {
                            goodsSupplierList.get(i).setSupplier(goodsSupplierList.get(i).getFullname());
                        }
                    }
                }
                PageInfo pageInfo = new PageInfo<>(goodsSupplierList);
                return pageInfo;
            } else if ("1".equals(type)) {
                List<CategoryDto> categoryList = supplierTerDao.getCategoryDetail(categoryid);
                if (categoryList != null && !categoryList.isEmpty()) {
                    for (int i = 0; i < categoryList.size(); i++) {
                        categoryids = categoryids + categoryList.get(i).getId() + ",";
                    }
                    if (StringUtils.isNotEmpty(categoryids)) {
                        categoryids = categoryids.substring(0, categoryids.length() - 1);
                    }
                }
                if (StringUtils.isNotEmpty(categoryids)) {
                    supGoodsVo.setCategoryid(categoryids);
                    goodsSupplierList = supplierTerDao.NoJdGoodsMessage2(supGoodsVo);
                    if (goodsSupplierList != null && !goodsSupplierList.isEmpty()) {
                        for (int i = 0; i < goodsSupplierList.size(); i++) {
                            goodsSupplierList.get(i).setSupplier(goodsSupplierList.get(i).getFullname());
                        }
                    }
                }
                PageInfo pageInfo = new PageInfo<>(goodsSupplierList);
                return pageInfo;
            } else {
                goodsSupplierList = supplierTerDao.NoJdGoodsMessage2(supGoodsVo);
                if (goodsSupplierList != null && !goodsSupplierList.isEmpty()) {
                    for (int i = 0; i < goodsSupplierList.size(); i++) {
                        goodsSupplierList.get(i).setSupplier(goodsSupplierList.get(i).getFullname());
                    }
                }
                PageInfo pageInfo = new PageInfo<>(goodsSupplierList);
                return pageInfo;
            }
        }
    }

    @Override
    public PageInfo SupplierGoodsList(SupplierGoodsVo supplierGoodsVo) {
        PageHelper.startPage(supplierGoodsVo.getPageNum(), supplierGoodsVo.getPageSize());
        supplierGoodsVo.setBaseurl(url);
        List<GoodsBrandListDto> goodsBrandListDtos = supplierTerDao.SupplierGoodsList(supplierGoodsVo);
        PageInfo pageInfo = new PageInfo<>(goodsBrandListDtos);
        return pageInfo;
    }

    @Override
    public Result supplierTerService(GoodsClassifyVo goodsClassifyVo) {
        goodsClassifyVo.setName(twbusiness);
        //查询一级商品库商品分类信息
        List<GoodsFirstClassifyDto> goodsFirstClassifyDtos = supplierTerDao.queryFirstGoodsClassify(goodsClassifyVo);
        for (int i = 0; i < goodsFirstClassifyDtos.size(); i++) {
            goodsClassifyVo.setFirstid(goodsFirstClassifyDtos.get(i).getId());
            //查询二级商品库商品分类信息
            List<GoodsSecondClassifyDto> goodsSecondClassifyDtos = supplierTerDao.querySecondGoodsClassify(goodsClassifyVo);
            for (int j = 0; j < goodsSecondClassifyDtos.size(); j++) {
                goodsClassifyVo.setSecondid(goodsSecondClassifyDtos.get(j).getId());
                //查询三级商品库商品分类信息
                List<GoodsThirdClassifyDto> goodsThirdClassifyDtos = supplierTerDao.queryThirdGoodsClassify(goodsClassifyVo);
                for (int k = 0; k < goodsThirdClassifyDtos.size(); k++) {
                    goodsClassifyVo.setThirdid(goodsThirdClassifyDtos.get(k).getId());
                    //查询四级商品库商品分类信息
                    List<GoodsFourthClassifyDto> goodsFourthClassifyDtos = supplierTerDao.queryFourthGoodsClassify(goodsClassifyVo);
                    goodsFirstClassifyDtos.get(i).setChildren(goodsSecondClassifyDtos);
                    goodsSecondClassifyDtos.get(j).setChildren(goodsThirdClassifyDtos);
                    goodsThirdClassifyDtos.get(k).setChildren(goodsFourthClassifyDtos);
                }
            }
        }
        return Result.ok(goodsFirstClassifyDtos);
    }

    @Override
    public Result SupplierGoodsBrandAdd(GoodsBrandAddVo goodsBrandAddVo) {
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        if (goodsBrandAddVo.getIsinquiry().equals("是")) {
            goodsBrandAddVo.setIsinquiry("Y");
            goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
        } else if (goodsBrandAddVo.getIsinquiry().equals("否")) {
            goodsBrandAddVo.setIsinquiry("N");
            goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
            goodsBrandAddVo.setMaxprice("");
        }

        if (goodsBrandAddVo.getFreightcharges().equals("是")) {
            goodsBrandAddVo.setFreightcharges("Y");
        } else if (goodsBrandAddVo.getFreightcharges().equals("否")) {
            goodsBrandAddVo.setFreightcharges("N");
        }
        //todo 物资图片 后端目前写死，之后再改
        goodsBrandAddVo.setUrlid("5403");
        //状态 默认为6，待上架
        goodsBrandAddVo.setState("6");
        //销量默认为0
        goodsBrandAddVo.setSalesVolume(0);
        //获取当前时间
        goodsBrandAddVo.setInputdate(time);
        //获取当前登录人信息
        String remoteUser = null;
        try {
            remoteUser = WebUtils.getRequest().getRemoteUser();
            if (com.alibaba.druid.util.StringUtils.isEmpty(remoteUser)) {
                remoteUser = WebUtils.getRequest().getParameter("username");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (remoteUser == null || remoteUser.equals("")) {
            remoteUser = "jiaoy01";
            goodsBrandAddVo.setUserid(remoteUser);
        } else {
            goodsBrandAddVo.setUserid(remoteUser);
        }
        if (goodsBrandAddVo.getDetails() == null || goodsBrandAddVo.getDetails().equals("")) {
            goodsBrandAddVo.setDetails("/40b715e0-9399-11e8-8e1f-6bda1ebf5787.txt");
        }

        try {
            //新增
            supplierTerDao.SupplierGoodsBrandAdd(goodsBrandAddVo);
            return Result.ok("新增成功");
        } catch (Exception e) {
            e.printStackTrace();
            return Result.ok("新增失败");
        }
    }

    @Override
    public PageInfo SupplierMaterielImport(MaterielImportVo materielImportVo) {
        PageHelper.startPage(materielImportVo.getPageNum(), materielImportVo.getPageSize());
        List<MaterielImportDto> materielImportDtos = supplierTerDao.SupplierMaterielImport(materielImportVo);
        for (int i = 0; i < materielImportDtos.size(); i++) {
            materielImportDtos.get(i).setSub(materielImportDtos.get(i).getId() + materielImportDtos.get(i).getName()
                    + materielImportDtos.get(i).getMateriecode() + materielImportDtos.get(i).getUnit() + materielImportDtos.get(i).getBrand()
                    + materielImportDtos.get(i).getBrandname() + materielImportDtos.get(i).getFTNPFirstCategoryName()
                    + materielImportDtos.get(i).getFTNPThreeCategoryName());
        }
        PageInfo pageInfo = new PageInfo<>(materielImportDtos);
        return pageInfo;
    }

    @Override
    public Result SupplierSalesarea(GoodsClassifyVo goodsClassifyVo) {
        goodsClassifyVo.setName(twbusiness);
        //销售区域一级查询
        List<SalesareaFirstNameDto> salesareaFirstNameDto = supplierTerDao.queryFirstSalesareaName(goodsClassifyVo);
        for (int H = 0; H < salesareaFirstNameDto.size(); H++) {
            goodsClassifyVo.setFirstid(salesareaFirstNameDto.get(H).getId());
            //销售区域二级查询
            List<SalesareaSecondNameDto> salesareaSecondNameDtos = supplierTerDao.querySecondSalesareaName(goodsClassifyVo);
            for (int i = 0; i < salesareaSecondNameDtos.size(); i++) {
                goodsClassifyVo.setSecondid(salesareaSecondNameDtos.get(i).getId());
                //销售区域三级查询
                List<SalesareaThirdNameDto> salesareaThirdNameDtos = supplierTerDao.queryThirdSalesareaName(goodsClassifyVo);
                for (int j = 0; j < salesareaThirdNameDtos.size(); j++) {
                    goodsClassifyVo.setThirdid(salesareaThirdNameDtos.get(j).getId());
                    //销售区域四级查询
                    List<SalesareaFourthNameDto> salesareaFourthNameDtos = supplierTerDao.queryFourthSalesareaName(goodsClassifyVo);
                    for (int k = 0; k < salesareaFourthNameDtos.size(); k++) {
                        goodsClassifyVo.setFourthid(salesareaFourthNameDtos.get(k).getId());
                        //销售区域五级查询
                        List<SalesareaFiveNameDto> salesareaFiveNameDtos = supplierTerDao.queryFiveSalesareaName(goodsClassifyVo);
                        salesareaFirstNameDto.get(H).setSalesareaNameDto(salesareaSecondNameDtos);
                        salesareaSecondNameDtos.get(i).setSalesareaNameDto(salesareaThirdNameDtos);
                        salesareaThirdNameDtos.get(j).setSalesareaNameDto(salesareaFourthNameDtos);
                        salesareaFourthNameDtos.get(k).setSalesareaNameDto(salesareaFiveNameDtos);
                    }
                }
            }
        }
        return Result.ok(salesareaFirstNameDto);
    }

    @Override
    public Result SupplierGoodsOnTheAudit(GoodsBrandOnTheAuditVo goodsBrandOnTheAuditVo) {
        goodsBrandOnTheAuditVo.setDatabase(twbusiness);
        //查询此商品状态是否为合格，或者为试用状态
        String code = supplierTerDao.GoodsBrandOnTheAudit(goodsBrandOnTheAuditVo);
        if (code.equals("合格") || code.equals("试用")) {
            //如果是C类商品，不走审批，直接上架
            if (goodsBrandOnTheAuditVo.getMaterialclassify().equals("C")) {
                supplierTerDao.UpdategoodsUpOrDownProcessRest_PS(goodsBrandOnTheAuditVo.getGoodsnum());
                return Result.ok("上架成功");
            }
            //查询是否是在审核的商品
            List<SupplierPageMessageDto> supplierPageMessageDtos = supplierTerDao.queryGoodsUpordown(goodsBrandOnTheAuditVo);
            for (int i = 0; i < supplierPageMessageDtos.size(); i++) {
                if (supplierPageMessageDtos.get(i).getMessage().equals("1")) {
                    return Result.ok("该商品正在审核中，请耐心等待");
                }
            }

            //查询商品库信息
            GoodsBrandOnTheAuditDto goodsBrandOnTheAuditDto = supplierTerDao.queryGoodsMessage(goodsBrandOnTheAuditVo);
            goodsBrandOnTheAuditDto.setApplyId(goodsBrandOnTheAuditVo.getUserid());
            goodsBrandOnTheAuditDto.setApplyName(goodsBrandOnTheAuditVo.getCnname());
            goodsBrandOnTheAuditDto.setBaseOrgId(goodsBrandOnTheAuditVo.getPositionothersystemid());
            goodsBrandOnTheAuditDto.setStationId(goodsBrandOnTheAuditVo.getPositionothersystemid());
            goodsBrandOnTheAuditDto.setTitle("商品上架信息");

            Map<String, Object> result = new HashMap<String, Object>();
            UUID uuid = UUID.randomUUID();
            if (goodsBrandOnTheAuditDto.getBaseOrgName() == null) {
                goodsBrandOnTheAuditDto.setBaseOrgName("");
            }
            if (goodsBrandOnTheAuditDto.getBrand() == null) {
                goodsBrandOnTheAuditDto.setBrand("");
            }
            if (goodsBrandOnTheAuditDto.getBrandname() == null) {
                goodsBrandOnTheAuditDto.setBrandname("");
            }
            if (goodsBrandOnTheAuditDto.getBussinessId() == null) {
                goodsBrandOnTheAuditDto.setBussinessId("");
            }
            if (goodsBrandOnTheAuditDto.getCreationDate() == null) {
                goodsBrandOnTheAuditDto.setCreationDate("");
            }
            if (goodsBrandOnTheAuditDto.getDeliverydate() == null) {
                goodsBrandOnTheAuditDto.setDeliverydate("");
            }
            if (goodsBrandOnTheAuditDto.getDeliveryplace() == null) {
                goodsBrandOnTheAuditDto.setDeliveryplace("");
            }
            if (goodsBrandOnTheAuditDto.getFreightcharges() == null) {
                goodsBrandOnTheAuditDto.setFreightcharges("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPFirstCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPFirstCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPFirstCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPFirstCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPSecondCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPSecondCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPThreeCategoryCode() == null) {
                goodsBrandOnTheAuditDto.setFTNPThreeCategoryCode("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPSecondCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPSecondCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getFTNPThreeCategoryName() == null) {
                goodsBrandOnTheAuditDto.setFTNPThreeCategoryName("");
            }
            if (goodsBrandOnTheAuditDto.getGoodsid() == null) {
                goodsBrandOnTheAuditDto.setGoodsid("");
            }
            if (goodsBrandOnTheAuditDto.getGoodsname() == null) {
                goodsBrandOnTheAuditDto.setGoodsname("");
            }
            if (goodsBrandOnTheAuditDto.getInvoicetype() == null) {
                goodsBrandOnTheAuditDto.setInvoicetype("");
            }
            if (goodsBrandOnTheAuditDto.getIsAsk() == null) {
                goodsBrandOnTheAuditDto.setIsAsk("");
            }
            if (goodsBrandOnTheAuditDto.getLink() == null) {
                goodsBrandOnTheAuditDto.setLink("");
            }
            if (goodsBrandOnTheAuditDto.getMaterialclassify() == null) {
                goodsBrandOnTheAuditDto.setMaterialclassify("");
            }
            if (goodsBrandOnTheAuditDto.getMaterielsid() == null) {
                goodsBrandOnTheAuditDto.setMaterielsid("");
            }
            if (goodsBrandOnTheAuditDto.getPrice() == null) {
                goodsBrandOnTheAuditDto.setPrice("");
            }
            if (goodsBrandOnTheAuditDto.getPrice2() == null) {
                goodsBrandOnTheAuditDto.setPrice2("");
            }
            if (goodsBrandOnTheAuditDto.getPricetype() == null) {
                goodsBrandOnTheAuditDto.setPricetype("");
            }
            if (goodsBrandOnTheAuditDto.getProcessCode() == null) {
                goodsBrandOnTheAuditDto.setProcessCode("");
            }
            if (goodsBrandOnTheAuditDto.getProcessId() == null) {
                goodsBrandOnTheAuditDto.setProcessId("");
            }
            if (goodsBrandOnTheAuditDto.getReason() == null) {
                goodsBrandOnTheAuditDto.setReason("");
            }
            if (goodsBrandOnTheAuditDto.getSalesarea() == null) {
                goodsBrandOnTheAuditDto.setSalesarea("");
            }
            if (goodsBrandOnTheAuditDto.getSalesareaname() == null) {
                goodsBrandOnTheAuditDto.setSalesareaname("");
            }
            if (goodsBrandOnTheAuditDto.getStationName() == null) {
                goodsBrandOnTheAuditDto.setStationName("");
            }
            if (goodsBrandOnTheAuditDto.getSuccessdate() == null) {
                goodsBrandOnTheAuditDto.setSuccessdate("");
            }
            if (goodsBrandOnTheAuditDto.getSupplier() == null) {
                goodsBrandOnTheAuditDto.setSupplier("");
            }
            if (goodsBrandOnTheAuditDto.getSupplierid() == null) {
                goodsBrandOnTheAuditDto.setSupplierid("");
            }
            if (goodsBrandOnTheAuditDto.getSystemCode() == null) {
                goodsBrandOnTheAuditDto.setSystemCode("");
            }
            if (goodsBrandOnTheAuditDto.getTaxrate() == null) {
                goodsBrandOnTheAuditDto.setTaxrate("");
            }
            if (goodsBrandOnTheAuditDto.getUnit() == null) {
                goodsBrandOnTheAuditDto.setUnit("");
            }
            JSONObject json = new JSONObject();
            json.element("applyId", goodsBrandOnTheAuditDto.getApplyId());
            json.element("applyName", goodsBrandOnTheAuditDto.getApplyName());
            json.element("baseOrgId", goodsBrandOnTheAuditDto.getBaseOrgId());
            json.element("baseOrgName", goodsBrandOnTheAuditDto.getBaseOrgName());
            json.element("bussinessId", goodsBrandOnTheAuditDto.getBussinessId());
            json.element("creationDate", goodsBrandOnTheAuditDto.getCreationDate());
            json.element("brand", goodsBrandOnTheAuditDto.getBrand());
            json.element("brandname", goodsBrandOnTheAuditDto.getBrandname());
            json.element("deliverydate", goodsBrandOnTheAuditDto.getDeliverydate());
            json.element("deliveryplace", goodsBrandOnTheAuditDto.getDeliveryplace());
            json.element("freightcharges", goodsBrandOnTheAuditDto.getFreightcharges());
            json.element("FTNPFirstCategoryCode", goodsBrandOnTheAuditDto.getFTNPFirstCategoryCode());
            json.element("FTNPFirstCategoryName", goodsBrandOnTheAuditDto.getFTNPFirstCategoryName());
            json.element("FTNPSecondCategoryCode", goodsBrandOnTheAuditDto.getFTNPSecondCategoryCode());
            json.element("FTNPSecondCategoryName", goodsBrandOnTheAuditDto.getFTNPSecondCategoryName());
            json.element("FTNPThreeCategoryCode", goodsBrandOnTheAuditDto.getFTNPThreeCategoryCode());
            json.element("FTNPThreeCategoryName", goodsBrandOnTheAuditDto.getFTNPThreeCategoryName());
            json.element("goodsid", goodsBrandOnTheAuditDto.getGoodsid());
            json.element("goodsname", goodsBrandOnTheAuditDto.getGoodsname());
            json.element("invoicetype", goodsBrandOnTheAuditDto.getInvoicetype());
            json.element("isAsk", goodsBrandOnTheAuditDto.getIsAsk());
            json.element("link", goodsBrandOnTheAuditDto.getLink());
            json.element("materialclassify", goodsBrandOnTheAuditDto.getMaterialclassify());
            json.element("materielsid", goodsBrandOnTheAuditDto.getMaterielsid());
            json.element("price", goodsBrandOnTheAuditDto.getPrice());
            json.element("price2", goodsBrandOnTheAuditDto.getPrice2());
            json.element("pricetype", goodsBrandOnTheAuditDto.getPricetype());
            json.element("processCode", goodsBrandOnTheAuditDto.getProcessCode());
            json.element("processId", goodsBrandOnTheAuditDto.getProcessId());
            json.element("reason", goodsBrandOnTheAuditDto.getReason());
            json.element("salesarea", goodsBrandOnTheAuditDto.getSalesarea());
            json.element("salesareaname", goodsBrandOnTheAuditDto.getSalesareaname());
            json.element("stationId", goodsBrandOnTheAuditDto.getStationId());
            json.element("stationName", goodsBrandOnTheAuditDto.getStationName());
            json.element("successdate", goodsBrandOnTheAuditDto.getSuccessdate());
            json.element("supplier", goodsBrandOnTheAuditDto.getSupplier());
            json.element("supplierid", goodsBrandOnTheAuditDto.getSupplierid());
            json.element("systemCode", goodsBrandOnTheAuditDto.getSystemCode());
            json.element("taxrate", goodsBrandOnTheAuditDto.getTaxrate());
            json.element("title", goodsBrandOnTheAuditDto.getTitle());
            json.element("unit", goodsBrandOnTheAuditDto.getUnit());
            try {
                System.out.println(json);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                //拼写接口报文
                RestTemplate restTemplate = new RestTemplate();
                //向接口传递数据
                //拼写好的报文提交
                HttpEntity<JSONObject> he = new HttpEntity<JSONObject>(json, headers);
                @SuppressWarnings("rawtypes")
                ResponseEntity<Map> resultjson = restTemplate.exchange(onTheAuditUrl, HttpMethod.POST, he, Map.class);
                Map<String, Object> restmap = resultjson.getBody();
//                JsonMapper jsonMapper = new JsonMapper();
                String retCode = restmap.get("retCode").toString();
                String processId = restmap.get("processId").toString();
                String reqno = restmap.get("reqno").toString();
                String retMsg = restmap.get("retMsg").toString();
                String fbcUrl = restmap.get("fbcUrl").toString();
                String bussinessType = restmap.get("bussinessType").toString();
                String bussinessId = restmap.get("bussinessId").toString();
//                Map<String,Object> jsonm = jsonMapper.fromJson(restmap.get("retCode").toString(), Map.class);
                if (retCode.equals("Y")) {
                    String time = null;
                    String time2 = null;
                    Date date = new Date();
                    SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    SimpleDateFormat d2 = new SimpleDateFormat("yyyyMMdd");
                    time = d.format(date);
                    time2 = d2.format(date);

                    goodsBrandOnTheAuditVo.setInputdate(time);
                    goodsBrandOnTheAuditVo.setCode("1");
                    goodsBrandOnTheAuditVo.setBpmurl(fbcUrl);
                    goodsBrandOnTheAuditVo.setProcessid(processId);
                    goodsBrandOnTheAuditVo.setReqno(reqno);
                    goodsBrandOnTheAuditVo.setBussinessid(bussinessId);
                    goodsBrandOnTheAuditVo.setBussinesstype(bussinessType);

                    //逻辑查询上下架次数
                    String num = supplierTerDao.queryUpOrDownNum(time2, twbusiness);
                    if (num.equals("") || num == null) {
                        String upnum = time2 + "0001";
                        goodsBrandOnTheAuditVo.setUpnum(upnum);
                    } else {
                        BigInteger b = new BigInteger(num);
                        BigInteger c = new BigInteger("1");
                        //BigInteger的加法运算
                        String upnum = b.add(c) + "";
                        goodsBrandOnTheAuditVo.setUpnum(upnum);
                    }
                    goodsBrandOnTheAuditVo.setSubject(goodsBrandOnTheAuditVo.getSupplier() + goodsBrandOnTheAuditVo.getName());
                    goodsBrandOnTheAuditVo.setAction("up");
                    goodsBrandOnTheAuditVo.setBpmid("0");
                    goodsBrandOnTheAuditVo.setUrl("http://174.34.53.78:8001/BPMProject/bpm/process-space!viewForm.do?instid=0&processname=UAESShopApply&processnodename=&grantor=&taskid=83802&title=");
                    try {
                        //新增商品上下架表数据
                        supplierTerDao.insertGoodsUpOrDown(goodsBrandOnTheAuditVo);
                        //新增上架流程表
                        supplierTerDao.insertintoUporDown(goodsBrandOnTheAuditVo);
                    } catch (Exception e) {
                        e.printStackTrace();
                        return Result.error("新增上下架信息错误");
                    }
                } else {
                    return Result.error("调用失败");
                }


            } catch (Exception e) {
                System.out.println("请求报文：" + json);
                System.out.println("请求调用失败" + e);
                return Result.error("服务器异常");
            }
            return Result.ok("已发起审批，请耐心等待");
        } else {
            return Result.error("供应商不是合格或试用供应商，不能上架！");
        }
    }

    /**
     * 商品库更改状态为上架审批回传
     *
     * @param map
     * @return
     */
    @Override
    public Result goodsUpOrDownProcessRest_PS(Map<String, Object> map) {
            String state = (String) map.get("state");
            String processid = (String) map.get("processid");
            String goodsnum = (String) map.get("goodsid");
            String opinion = (String) map.get("opinion");

            String time = null;
            Date date = new Date();
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = d.format(date);

            if ("Y".equals(state)) {
                //更新商品上架
                supplierTerDao.UpdategoodsUpOrDownProcessRest_PS(goodsnum);
                //更新上下架表状态
                supplierTerDao.UpdategoodsUpOrDownProcessRest(processid, time, twbusiness);
                //更新上下架流程表
                supplierTerDao.UpdateUporDownProcess(twbusiness, processid, time);
                return Result.ok("上架成功");
            } else {
                //终止操作上架，不同意上架
                supplierTerDao.EndgoodsUpOrDownProcessRest(processid, time, twbusiness);
                //终止操作上下架流程表，不同意上架
                supplierTerDao.UpdateEndUporDownProcess(twbusiness, processid, time);
                return Result.error("上架失败，原因是：" + opinion);
            }
    }

    @Override
    public Result GoodsBrandSoldOut(GoodsBrandSoldOutVo goodsBrandSoldOutVo) {
        String time = null;
        Date date = new Date();
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        time = d.format(date);
        List<GoodsBrandSoldOutIdVo> goodsBrandSoldOutIdVos = goodsBrandSoldOutVo.getGoodsBrandSoldOutIdVos();
        for (int i = 0; i < goodsBrandSoldOutIdVos.size(); i++) {
            if (goodsBrandSoldOutIdVos.get(i).getId() != null && !goodsBrandSoldOutIdVos.get(i).getId().equals("")) {
                goodsBrandSoldOutIdVos.get(i).setDescription(goodsBrandSoldOutVo.getReason());
                if (goodsBrandSoldOutIdVos.get(i).getDescription() != null && !goodsBrandSoldOutIdVos.get(i).getDescription().equals("")) {
                    //获取当前时间
                    goodsBrandSoldOutIdVos.get(i).setSuccessdate(time);
                    //更改状态
                    supplierTerDao.GoodsBrandSoldOut(goodsBrandSoldOutIdVos.get(i));
                    return Result.ok("下架成功！");
                } else {
                    return Result.error("请输入下架原因！");
                }
            } else {
                return Result.error("请选择商品后再试");
            }
        }
        return Result.error("下架失败");
    }

    /**
     * 通威商品库编辑
     *
     * @param goodsBrandAddVo
     * @return
     */
    @Override
    public Result GoodsBrandUpdate(GoodsBrandAddVo goodsBrandAddVo) {
        if (goodsBrandAddVo.getState().equals("1")) {
            return Result.error("上架商品不能编辑");
        } else {
            String time = null;
            Date date = new Date();
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = d.format(date);
            if (goodsBrandAddVo.getIsinquiry().equals("是")) {
                goodsBrandAddVo.setIsinquiry("Y");
                goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
            } else if (goodsBrandAddVo.getIsinquiry().equals("否")) {
                goodsBrandAddVo.setIsinquiry("N");
                goodsBrandAddVo.setPrice(goodsBrandAddVo.getMinprice());
                goodsBrandAddVo.setMaxprice("");
            }

            if (goodsBrandAddVo.getFreightcharges().equals("是")) {
                goodsBrandAddVo.setFreightcharges("Y");
            } else if (goodsBrandAddVo.getFreightcharges().equals("否")) {
                goodsBrandAddVo.setFreightcharges("N");
            }
            //todo 物资图片 后端目前写死，之后再改
            goodsBrandAddVo.setUrlid("5403");
//            //状态 默认为6，待上架
//            goodsBrandAddVo.setState("6");
//            //销量默认为0
//            goodsBrandAddVo.setSalesVolume(0);
//            //获取当前时间
            goodsBrandAddVo.setInputdate(time);
            //获取当前登录人信息
            String remoteUser = null;
            try {
                remoteUser = WebUtils.getRequest().getRemoteUser();
                if (com.alibaba.druid.util.StringUtils.isEmpty(remoteUser)) {
                    remoteUser = WebUtils.getRequest().getParameter("username");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (remoteUser == null || remoteUser.equals("")) {
                remoteUser = "jiaoy01";
                goodsBrandAddVo.setUserid(remoteUser);
            } else {
                goodsBrandAddVo.setUserid(remoteUser);
            }
//            if (goodsBrandAddVo.getDetails() == null || goodsBrandAddVo.getDetails().equals("")) {
//                goodsBrandAddVo.setDetails("/40b715e0-9399-11e8-8e1f-6bda1ebf5787.txt");
//            }
            try {
                //编辑商品库
                supplierTerDao.GoodsBrandUpdate(goodsBrandAddVo);
                return Result.ok("更新成功");
            } catch (Exception e) {
                e.printStackTrace();
                return Result.ok("更新失败");
            }
        }

    }
}