package com.ekingwin.bas.cloud.supplier.web;

import com.ekingwin.bas.cloud.protal.vo.*;
import com.ekingwin.bas.cloud.supplier.service.SupplierTerService;
import com.ekingwin.bas.cloud.supplier.vo.ShipmnetsVo;
import com.ekingwin.bas.cloud.supplier.vo.SupplierGoodsVo;
import com.ekingwin.bas.cloud.supplier.vo.SupplierVo;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;


/**
 * @author kan
 * @version 1.0.0
 * @ClassName SupplierTerController.java
 * @Description TODO
 * @createTime 2020/3/25 14:28
 */
@RestController
@RequestMapping(value = "/supplier/")
@Api(tags = "供应商平台", description = "供应商平台", value = "供应商平台")
public class SupplierTerController {
    @Autowired
    private SupplierTerService supplierTerService;

    @ApiOperation(value = "供应商平台订单列表接口")
    @PostMapping(value = "/orderList")
    public Result orderList(@RequestBody SupplierVo SupplierVo) throws Exception{
       PageInfo pageInfo= supplierTerService.orderList(SupplierVo);
        return Result.ok(pageInfo);
    }

    @ApiOperation(value = "供应商平台订单发货修改状态接口")
    @PostMapping(value = "/sugoodsStateUpdate")
    public Result sugoodsStateUpdate(@RequestBody ShipmnetsVo ShipmnetsVo) throws Exception{
        Boolean f= supplierTerService.sugoodsStateUpdate(ShipmnetsVo);
        return Result.ok(f);
    }

//    @ApiOperation(value = "非京东商品库查询")
//    @PostMapping(value = "/NoJdGoodsMessage")
//    public Result NoJdGoodsMessage(@RequestBody SupGoodsVo SupGoodsVo) throws Exception{
//        PageInfo pageInfo= supplierTerService.NoJdGoodsMessage(SupGoodsVo);
//        return Result.ok(pageInfo);
//    }
      @ApiOperation(value = "招商平台商品库查询", notes = "招商平台商品库查询")
      @PostMapping(value = "/SupplierGoodsList")
      public Result SupplierGoodsList(@RequestBody SupplierGoodsVo supplierGoodsVo) throws Exception{
       PageInfo pageInfo = supplierTerService.SupplierGoodsList(supplierGoodsVo);
       return  Result.ok(pageInfo);
      }

      @ApiOperation(value = "招商平台商品库商品分类", notes = "招商平台商品库商品分类")
      @PostMapping(value = "/SupplierGoodsClassifys")
      public Result SupplierGoodsClassifys(@RequestBody GoodsClassifyVo goodsClassifyVo) throws Exception{
        return supplierTerService.supplierTerService(goodsClassifyVo);
      }

      @PostMapping(value = "/SupplierGoodsBrandAdd")
      @ApiOperation(value = "供应商平台商品库新增", notes = "供应商平台商品库新增")
      public Result SupplierGoodsBrandAdd(@RequestBody GoodsBrandAddVo goodsBrandAddVo) throws Exception{
        return supplierTerService.SupplierGoodsBrandAdd(goodsBrandAddVo);
      }

    @PostMapping(value = "/SupplierMaterielImport")
    @ApiOperation(value = "供应商平台商品库新增中基本信息子接口的商品名称查询", notes = "供应商平台商品库新增中基本信息子接口的商品名称查询")
    public Result SupplierMaterielImport(@RequestBody MaterielImportVo materielImportVo) throws Exception{
        PageInfo pageInfo = supplierTerService.SupplierMaterielImport(materielImportVo);
        return  Result.ok(pageInfo);
    }

    @PostMapping(value = "/SupplierSalesarea")
    @ApiOperation(value = "供应商平台商品库新增销售区域查询", notes = "供应商平台商品库新增销售区域查询")
    public Result SupplierSalesarea(@RequestBody GoodsClassifyVo goodsClassifyVo) throws Exception{
        return  supplierTerService.SupplierSalesarea(goodsClassifyVo);
    }
    @PostMapping(value = "/SupplierGoodsOnTheAudit")
    @ApiOperation(value = "供应商平台商品库更改状态为上架发起", notes = "供应商平台商品库更改状态为上架发起")
    public Result SupplierGoodsOnTheAudit(@RequestBody GoodsBrandOnTheAuditVo goodsBrandSoldOutVo) throws Exception{
        return supplierTerService.SupplierGoodsOnTheAudit(goodsBrandSoldOutVo);
    }

    @PostMapping(value = "/goodsUpOrDownProcessRest_PS")
    @ApiOperation(value = "供应商平台商品库更改状态为上架审批回传", notes = "供应商平台商品库更改状态为上架审批回传")
    public Result goodsUpOrDownProcessRest_PS(Map<String,Object> map) throws Exception{
        return supplierTerService.goodsUpOrDownProcessRest_PS(map);
    }

    @PostMapping(value = "/GoodsBrandSoldOut")
    @ApiOperation(value = "供应商平台商品库更改状态为下架", notes = "供应商平台商品库更改状态为下架")
    public Result GoodsBrandSoldOut(@RequestBody GoodsBrandSoldOutVo goodsBrandSoldOutVo) throws Exception{
        return supplierTerService.GoodsBrandSoldOut(goodsBrandSoldOutVo);
    }
    @PostMapping(value = "/GoodsBrandUpdate")
    @ApiOperation(value = "供应商平台通威商品库编辑", notes = "供应商平台通威商品库编辑")
    public Result GoodsBrandUpdate(@RequestBody GoodsBrandAddVo goodsBrandAddVo) throws Exception{
        return supplierTerService.GoodsBrandUpdate(goodsBrandAddVo);
    }
}
