package com.ekingwin.bas.cloud.util;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * text文件读写
 */
public class ReadTxtUtil {

    public static void main(String args[]) throws Exception{
        System.out.println(readFile1("D:\\test\\test.txt"));
        //writeFile("D:\\test\\test.txt", "测试文件写入");
    }

    /**
     * 读入TXT文件
     */
    public static String readFile(String fielPath) {
        // 绝对路径或相对路径都可以，写入文件时演示相对路径,读取以上路径的input.txt文件
        String pathname = fielPath;
        //防止文件建立或读取失败，用catch捕捉错误并打印，也可以throw;
        //不关闭文件会导致资源的泄露，读写文件都同理
        String result = "";
        try {
            FileReader reader = new FileReader(pathname);
            // 建立一个对象，它把文件内容转成计算机能读懂的语言
            BufferedReader br = new BufferedReader(reader);

            String s = null;
            while ((s = br.readLine()) != null) {
                result = result  + s;
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return  result;
    }
    public static String readToString(String fileName) {
        String encoding = "UTF-8";
        File file = new File(fileName);
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            return new String(filecontent, encoding);
        } catch (UnsupportedEncodingException e) {
            System.err.println("The OS does not support " + encoding);
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 读入TXT文件
     */
    public static String readFile1(String fielPath) throws Exception {

        String pathname = fielPath;

        FileInputStream fileIn = new FileInputStream(pathname);
        ByteBuffer byteBuf = ByteBuffer.allocate(65535);
        FileChannel fileChannel = fileIn.getChannel();
        StringBuilder stringBuilder=new StringBuilder();
        int bytes = -1;
        do {
            bytes = fileChannel.read(byteBuf);
            if (bytes != -1) {
                byte[] array = new byte[bytes];
                byteBuf.flip();
                byteBuf.get(array);
                byteBuf.clear();
                //拿array做事情
                stringBuilder.append(new String(array));
            }
        } while (bytes > 0);
        byteBuf.clear();
        fileChannel.close();
        fileIn.close();

        return  stringBuilder.toString();
    }


    /**
     * 写入TXT文件
     */
    public static void writeFile(String filePath, String fileConent) {
        try {
            // 相对路径，如果没有则要建立一个新的output.txt文件
            File writeName = new File(filePath);
            // 创建新文件,有同名的文件的话直接覆盖
            writeName.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(writeName));
            out.write(fileConent);
            // 把缓存区内容压入文件
            out.flush();
            // 最后关闭文件
            out.close();

        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}


