package com.ekingwin.bas.cloud.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-27 15:28
 **/
@ApiModel("商品详情")
@Data
public class GoodsDeatilVo {

    @ApiModelProperty(value = "商品主键",required = false)
    private Long goodsId;

    /**
     * 商品信息
     */
    @ApiModelProperty(value = "商品信息",required = false)
    private Map<String,Object> goodsMap;

    /**
     * 供应商运费
     */
    @ApiModelProperty(value = "供应商运费",required = false)
    private List<IpGoodsSuppliersVo> suppliersList;

    /**
     * 商品价格表
     */
    @ApiModelProperty(value = "商品价格",required = false)
    private List<IpGoodsPriceVo> priceList;

    @ApiModelProperty(value = "图片",required = false)
    private String urlid;

    @ApiModelProperty(value = "图片链接",required = false)
    private List<String> urlpath;

    @ApiModelProperty(value = "商品描述",required = false)
    private String details;


    @ApiModelProperty(value = "规格参数",required = false)
    private String description;


    @ApiModelProperty(value = "供应商厂商信息")
    private GoodsSupplierInfoVo supplierInfo;





}
