package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-08-06 14:00
 **/
@RestController
@RequestMapping(value = "/file/")
@Api(tags = "文件管理", description = "文件管理", value = "文件管理")
public class FileController {

    @Value("${goods.targetDir}")
    private String fileDirPath;

    @Value("${goods.baseurl}")
    private String basePath;

    @RequestMapping("/uploads")
    @ResponseBody
    public Result fileUpload(HttpServletRequest request) throws Exception {

        List<MultipartFile> files =((MultipartHttpServletRequest)request).getFiles("file");
        List<String> fileList=new ArrayList<>();
        if (files !=null && files.size()>0){
            for (MultipartFile file : files) {
                String filename=file.getOriginalFilename();
                String fileType = filename.split("\\.")[1];
                Long uuid = System.currentTimeMillis();
                String newFileName = uuid+ "." + fileType;
                File targetFile = new File(fileDirPath);
                if(!targetFile.exists()){
                    targetFile.mkdirs();
                }
                String filePath = fileDirPath+"/" + newFileName;
                fileList.add(basePath+"/file/file/goods/"+ newFileName);
                FileOutputStream out = new FileOutputStream(filePath);
                out.write(file.getBytes());
                out.flush();
                out.close();
            }
        }
        return  Result.ok(fileList);
    }
}
