package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.GoodsEvaluationAgainDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationDto;
import com.ekingwin.bas.cloud.dto.IpGoodsEvaluationPageDto;
import com.ekingwin.bas.cloud.entity.IpGoodsEvaluation;
import com.ekingwin.bas.cloud.service.IpGoodsEvaluationService;
import com.ekingwin.bas.cloud.util.Result;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: IpGoodsEvaluationController
 * @Author: liujunfeng
 * @Date: 2019/10/25 17:50
 * @description:
 */
@RestController
@RequestMapping(value = "/goodsEvaluation/")
@Api(tags = "商品评价", description = "商品评价", value = "商品评价")
public class IpGoodsEvaluationController {

    @Autowired
    IpGoodsEvaluationService evaluationService;

    @PostMapping(value = "saveGoodsEvaluation")
    @ApiOperation(value = "新增商品评价",notes = "新增商品评价")
    public Result saveGoodsEvaluation(@RequestBody IpGoodsEvaluationDto evaluationDto) throws Exception{
        evaluationService.saveGoodsEvaluation(evaluationDto);
        return Result.ok();
    }

    @PostMapping(value = "selectGoodsEvaluation")
    @ApiOperation(value = "查询商品评价",notes = "查询商品评价")
    public Result selectGoodsEvaluation(@RequestBody IpGoodsEvaluationPageDto evaluationDto) throws Exception{
        PageInfo pageInfo = evaluationService.selectGoodsEvaluation(evaluationDto);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "selectGoodsComprehensiveScore")
    @ApiOperation(value = "查询商品综合评分平均分",notes = "查询商品综合评分平均分")
    public Result selectGoodsComprehensiveScore(@RequestBody IpGoodsEvaluationPageDto evaluationDto) throws Exception{
        IpGoodsEvaluation goodsEvaluation = evaluationService.selectGoodsComprehensiveScore(evaluationDto);
        return Result.ok(goodsEvaluation);
    }

    @PostMapping(value = "replyGoodsEvaluation")
    @ApiOperation(value = "商品评价回复",notes = "商品评价回复")
    public Result replyGoodsEvaluation(@RequestBody GoodsEvaluationAgainDto evaluationAgain) throws Exception{
        return evaluationService.replyGoodsEvaluation(evaluationAgain);
    }

    @PostMapping(value = "deleteReplyAndEvaluation")
    @ApiOperation(value = "删除评价和回复",notes = "删除评价和回复")
    public Result deleteReplyAndEvaluation(@RequestBody GoodsEvaluationAgainDto evaluationAgain) throws Exception{
        return evaluationService.deleteReplyAndEvaluation(evaluationAgain);
    }
}
