package com.ekingwin.bas.cloud.web;

import com.ekingwin.bas.cloud.dto.IpMobileAdvertisingDto;
import com.ekingwin.bas.cloud.dto.IpMobileAdvertisingPageDto;
import com.ekingwin.bas.cloud.dto.MainGoodsDataDto;
import com.ekingwin.bas.cloud.dto.MobileAdvertisingDto;
import com.ekingwin.bas.cloud.service.MainGoodsDataService;
import com.ekingwin.bas.cloud.util.BackResult;
import com.ekingwin.bas.cloud.util.PublicJsonObject;
import com.ekingwin.bas.cloud.util.Result;
import com.ekingwin.bas.cloud.vo.MainGoodsDataVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author 许世文
 * @Date 2019/8/6 14:49
 * @Version 1.0
 **/
@RestController
@RequestMapping(value = "/maingoods")
@Api(tags = "首页商品广告位管理")
public class MainGoodsController {

    @Autowired
    private MainGoodsDataService mainGoodsDataService;

    @PostMapping(value = "addMainGoodsData")
    @ApiOperation(value = "新增首页图片数据",notes = "新增首页图片数据")
    public Result addMainGoodsData(@RequestBody MainGoodsDataDto mainGoodsDataDto) throws Exception{
        mainGoodsDataService.addMainGoodsData(mainGoodsDataDto);
        return Result.ok();
    }

    @PostMapping(value = "getMainGoodsData")
    @ApiOperation(value = "获取首页图片",response = MainGoodsDataVo.class)
    public Result getMainGoodsData(@RequestBody MainGoodsDataDto mainGoodsDataDto) throws Exception{
        MainGoodsDataVo mainGoodsDataVo = mainGoodsDataService.getMainGoodsData(mainGoodsDataDto);
        return Result.ok(mainGoodsDataVo);
    }

    @PostMapping(value = "updateMainGoodsData")
    @ApiOperation(value = "修改首页图片数据",notes = "修改首页图片数据")
    public Result updateMainGoodsData(@RequestBody MainGoodsDataDto mainGoodsDataDto) throws Exception{
        mainGoodsDataService.updateMainGoodsData(mainGoodsDataDto);
        return Result.ok();
    }

    @PostMapping(value = "deleteMainGoodsData")
    @ApiOperation(value = "删除首页图片数据",notes = "删除首页图片数据")
    public Result deleteMainGoodsData(@RequestBody MainGoodsDataDto mainGoodsDataDto) throws Exception{
        mainGoodsDataService.deleteMainGoodsDate(mainGoodsDataDto);
        return Result.ok();
    }


    @PostMapping(value = "addMobileAdvertising")
    @ApiOperation(value = "新增APP首页图片数据",notes = "新增APP首页图片数据")
    public Result addMobileAdvertising(@RequestBody IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception{
        String string = mainGoodsDataService.addMobileAdvertising(mobileAdvertisingDto);
        return Result.ok(string);
    }

    @PostMapping(value = "updateMobileAdvertising")
    @ApiOperation(value = "修改APP首页图片数据",notes = "修改APP首页图片数据")
    public Result updateMobileAdvertising(@RequestBody IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception{
        String string = mainGoodsDataService.updateMobileAdvertising(mobileAdvertisingDto);
        return Result.ok(string);
    }

    @PostMapping(value = "deleteMobileAdvertising")
    @ApiOperation(value = "删除APP首页图片数据",notes = "删除APP首页图片数据")
    public Result deleteMobileAdvertising(@RequestBody IpMobileAdvertisingDto mobileAdvertisingDto) throws Exception{
        mainGoodsDataService.deleteMobileAdvertising(mobileAdvertisingDto);
        return Result.ok();
    }

    @PostMapping(value = "queryAdvertisingList")
    @ApiOperation(value = "移动端广告位pc列表查询",notes = "移动端广告位pc列表查询")
    public Result queryAdvertisingList(@RequestBody IpMobileAdvertisingPageDto pageDto) throws Exception{
        PageInfo<MobileAdvertisingDto> pageInfo = mainGoodsDataService.queryAdvertisingList(pageDto);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "queryAdvertising")
    @ApiOperation(value = "移动端广告位pc查询",notes = "移动端广告位pc查询")
    public Result queryAdvertising(@RequestBody IpMobileAdvertisingPageDto pageDto) throws Exception{
        MobileAdvertisingDto mobileAdvertisingDto = mainGoodsDataService.queryAdvertising(pageDto);
        return Result.ok(mobileAdvertisingDto);
    }

    @PostMapping(value = "queryAdvertisingLogsList")
    @ApiOperation(value = "移动端广告位日志列表查询",notes = "移动端广告位日志列表查询")
    public Result queryAdvertisingLogsList(@RequestBody IpMobileAdvertisingPageDto pageDto) throws Exception{
        PageInfo<MobileAdvertisingDto> pageInfo = mainGoodsDataService.queryAdvertisingLogsList(pageDto);
        return Result.ok(pageInfo);
    }

    @PostMapping(value = "queryAdvertise")
    @ApiOperation(value = "移动端广告位app查询",notes = "移动端广告位app查询")
    public Result queryAdvertise(@RequestBody IpMobileAdvertisingPageDto pageDto) throws Exception{
        PageInfo<MobileAdvertisingDto> pageInfo = mainGoodsDataService.queryAdvertise(pageDto);
        return Result.ok(pageInfo);
    }
    @GetMapping(value = "/searchRecommend")
    @ApiOperation(value = "新品上架和热门采购",notes = "新品上架和热门采购")
    public BackResult searchRecommend() throws Exception{
       Map<String,Object> pageInfo = mainGoodsDataService.searchRecommend();
        return PublicJsonObject.json(pageInfo);
    }

}
