package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.entity.IpGoodProcess;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface IpGoodProcessMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpGoodProcess record);

    int insertSelective(IpGoodProcess record);

    IpGoodProcess selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpGoodProcess record);

    int updateByPrimaryKey(IpGoodProcess record);

    /**
     * 更新流程实例号
     * @param instid
     * @param id
     * @return
     */
    int updateInstid(@Param(value = "instid") String instid,@Param(value = "id") Long id);

    /**
     * 根据流程实例号
     * @param instid
     * @return
     */
    IpGoodProcess getGoodsProcessByinstid(String instid);


    /**
     * 修改流程审批状态
     * @param record
     * @return
     */
    int updteStatusEnd(IpGoodProcess record);


    /**
    * 根据流程实例号获取商品类型
    * @Param:  * @param instid
    * @return: java.lang.String
    * @Author: zhangjie
    * @Date: 2019/11/9 14:27
    */
    String getGoodsCategory(String instid);

}