package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.InsertMap;
import com.ekingwin.bas.cloud.entity.IpGoodsEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @program: rcworkspace
 * @description:主表信息修改
 * @author: zhangjie
 * @create: 2019-06-27 16:07
 **/
@Repository
public interface IpGoodsDraftMapper {

    /**
     * 新增商品
     * @param insertMap
     * @return
     */
    int insertGoods(InsertMap insertMap);

    /**
     * 修改商品信息
     * @param insertMap
     * @return
     */
    int updateGoods(InsertMap insertMap);

    /**
     * 根据流程表ID删除商品主数据
     * @param id
     * @return
     */
    int deleteGoodsProcess(Long id);

    /**
     * 根据流程i主表id获取详情
     * @param id
     * @return
     */
    Map<String,Object> getGoodsDetail(Long id);


}
