package com.ekingwin.bas.cloud.protal.service.Impl;

import com.ekingwin.bas.cloud.protal.dao.HomepageSearchMapper;
import com.ekingwin.bas.cloud.protal.dto.*;
import com.ekingwin.bas.cloud.protal.service.IHomepageSearchService;
import com.ekingwin.bas.cloud.protal.vo.HomepageQueryVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Primary
public class HomepageSearchServiceImpl implements IHomepageSearchService {
    @Value("${img.url}")
    private String url;

    @Autowired
    private HomepageSearchMapper homepageSearchMapper;

    /**
     * 首页搜索
     *
     * @param homepageQueryVo
     * @return
     */
    @Override
    public PageInfo HomepageQueryList(HomepageQueryVo homepageQueryVo) {
        PageHelper.startPage(homepageQueryVo.getPagenum(), homepageQueryVo.getPagesize());
        homepageQueryVo.setUrl(url);
        //查询总个数以及供应商
        HomepageQueryListDto totalnum = homepageSearchMapper.HomepageQuerytotalnum(homepageQueryVo);
        //查询首页搜索分类
        List<HomepageQueryCategoryDto> category = homepageSearchMapper.HomepageQueryCategory(homepageQueryVo);
        //查询首页搜索品牌
        List<HomepageQueryBrandsDto> brands = homepageSearchMapper.HomepageQueryBrands(homepageQueryVo);
        //查询首页搜索型号
        List<HomepageQueryModelDto> model = homepageSearchMapper.HomepageQueryModel(homepageQueryVo);
        //首页搜索商品分类
        List<HomepageQueryMaterialclassifyDto> materialclassify = homepageSearchMapper.HomepageQueryMaterialclassify(homepageQueryVo);
        //首页搜索京东或者非京东
        List<HomepageQueryTypeDto> type = homepageSearchMapper.HomepageQueryType(homepageQueryVo);
        for (int j = 0; j < type.size(); j++) {
            if(type.get(j).getType().equals("Y")){
                type.get(j).setType("京东");
            }else if(type.get(j).getType().equals("N")){
                type.get(j).setType("非京东");
            }
        }

        //首页搜索商品全部信息
        List<HomepageQueryGoodsListDto> goodslist = homepageSearchMapper.HomepageQueryGoodsList(homepageQueryVo);
        for (int k = 0; k < goodslist.size(); k++) {
            goodslist.get(k).setGoodstype("非京东");
            goodslist.get(k).setFullname(goodslist.get(k).getSupplier());
        }

        totalnum.setType(type);
        totalnum.setBrands(brands);
        totalnum.setCategory(category);
        totalnum.setGoodslist(goodslist);
        totalnum.setMaterialclassify(materialclassify);
        totalnum.setModel(model);
        totalnum.setSupplier("{}");
        ArrayList content = new ArrayList<>();
        content.add(totalnum);
        PageInfo pageInfo = new PageInfo<>(content);
        return pageInfo;
    }
}
