package com.ekingwin.bas.cloud.util;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("固定返回参数")
public class BackResult<T> {

    public BackResult() {
		super();
	}
    @ApiModelProperty("响应状态码，200成功")
	private Integer code;
    @ApiModelProperty("响应提示信息")
    private String msg;
    @ApiModelProperty("返回具体的对象")
    private T data;

    public static BackResult successResponse() {
        return new BackResult(0);
    }

    public static BackResult successResponse(Object data) {
        return new BackResult(0, data);
    }

    public static BackResult successResponse(Integer code, Object o) {
        return new BackResult(code, o);
    }
    public static BackResult successResponse(Integer code, String msg, Object o) {
        return new BackResult(code,msg, o);
    }
    public static BackResult successResponse(Integer code, String msg) {
        return new BackResult(code,msg);
    }
    public static BackResult successResponse(String msg, Object o) {
        return new BackResult(msg, o);
    }

    public static BackResult failResponse(Integer code, String msg) {
        return new BackResult(code, msg);
    }

    public static BackResult failResponse(Integer code) {
        return new BackResult(code);
    }

    public static BackResult failResponse(String msg) {
        return new BackResult(1, msg);
    }



    public BackResult(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public BackResult(Integer code, T data) {
        this.code = code;
        this.data = data;
    }

    public BackResult(Integer code) {
        this.code = code;
    }

    public BackResult(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }
    public BackResult(T data) {
        this.code = 0;
        this.msg = "SUCCESS";
        this.data = data;
    }



    public BackResult(String msg) {
        this.code = 0;
        this.msg = msg;
        this.data = null;
    }

    public BackResult(String msg, T data) {
        this.code = 0;
        this.msg = msg;
        this.data = data;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "ResponseData{" + "code=" + code + ", msg='" + msg + '\'' + ", data=" + data + '}';
    }
}
