package com.ekingwin.bas.cloud.util;

import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @description:  日期处理
 *
 * @create: 2018-07-04 15:27
 **/
public class DateUtils {

	/** 时间格式(yyyy-MM-dd) */
	public static String DATE_PATTERN = "yyyy-MM-dd";

	/** 时间格式(yyyy-MM-dd HH:mm:ss) */
	public static String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

	public static String DATETIMEPATTERN="yyyyMMddHHmmss";
    /**
     *  时间格式(yyyyMMdd)
     */
    public static String DATE_PATTERN1 = "yyyyMMdd";

    /**
     * 日期格式化 日期格式为：yyyy-MM-dd
     * @param date  日期
     * @return  返回yyyy-MM-dd格式日期
     */
	public static String format(Date date) {
        return format(date, DATE_PATTERN);
    }
    
    /**
     * 日期格式化 日期格式为：yyyy-MM-dd
     * @param date  日期
     * @return  返回yyyy-MM-dd格式日期
     */
    public static String formatPattern(Date date) {
        return format(date, DATE_TIME_PATTERN);
    }
    

    /**
     * 日期格式化 日期格式为：yyyy-MM-dd
     * @param date  日期
     * @param pattern  格式，如：DateUtils.DATE_TIME_PATTERN
     * @return  返回yyyy-MM-dd格式日期
     */
    public static String format(Date date, String pattern) {
        if(date != null){
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    /**
     * 日期格式化
     * @param date
     * @return yyyyMMddHHmmss
     */
    public static String dateformat2(Date date) {
        if(date != null){
            SimpleDateFormat df = new SimpleDateFormat(DATETIMEPATTERN);
            return df.format(date);
        }
        return null;
    }

    /**
     * 日期格式化  yyyyMMdd
     * @param date
     * @return  yyyyMMdd
     */
    public static String dateformat3(Date date) {
        if(date != null){
            SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN1);
            return df.format(date);
        }
        return null;
    }


    /**
     * 字符串转换成日期
     * @param strDate 日期字符串
     * @param pattern 日期的格式，如：DateUtils.DATE_TIME_PATTERN
     */
    public static Date stringToDate(String strDate, String pattern){
        if (StringUtils.isBlank(strDate)){
            return null;
        }
        SimpleDateFormat lsdFormat = new SimpleDateFormat(pattern);
        Date date=null;
        try {
            date=lsdFormat.parse(strDate);
        }catch (Exception e){
            e.printStackTrace();
        }
        return date;
    }

    /**
     * 转换
     * @param dateStr
     * @return
     * @throws Exception
     */
    public static Date strToDateFormat(String dateStr) throws Exception {


        SimpleDateFormat formatter  = new SimpleDateFormat(DATE_PATTERN);
        SimpleDateFormat formatter2  = new SimpleDateFormat(DATE_PATTERN1);
        Date  date = formatter2.parse(dateStr);
        String  dString = formatter.format(date);
        return DateUtils.stringToDate(dString,DATE_PATTERN);
    }

    /**
     * 判断是否同一天
     * @param startDate
     * @param endDate
     * @return
     */
    public  static boolean isSameDay(Date startDate,Date endDate){

        return org.apache.commons.lang.time.DateUtils.isSameDay(startDate,endDate);
    }

    /**
     * 判断是否同一天
     * @param startTime
     * @param endTime
     * @return
     */
    public  static  boolean isSameDayStr(String startTime,String endTime) throws Exception{
        Date startDate= DateUtils.stringToDate(startTime,DATE_PATTERN);
        Date endDate= DateUtils.stringToDate(endTime,DATE_PATTERN);
        return org.apache.commons.lang.time.DateUtils.isSameDay(startDate,endDate);
    }

    /**
     * 根据同一天两个日期计算小时 数
     * @param startDate
     * @param endDate
     * @return
     */
    public  static  double getDatePoor(Date startDate,Date endDate){

        //计算两个日期的小时差
        long diff = endDate.getTime() - startDate.getTime();

        long nd = 1000 * 24 * 60 * 60;
        long nh = 1000 * 60 * 60;
        long nm = 1000 * 60;

        //判断是否超过30分钟
        double bz=30;
        // 计算差多少小时
        double hour = diff % nd / nh;

        // 计算差多少分钟
        long min = diff % nd % nh / nm;
        //不满半小时按半个小时计算大于30分钟，算一个小时
        if (min !=0){
            if (min<=bz){
                hour=hour+0.5;
            }else {
                hour=hour+1;
            }
        }
        return  hour;
    }

    /**
     * 计算两个日期相差天数
     * @param date1
     * @param date2
     * @return
     */
    public static int daysBetween(Date date1,Date date2){
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long between_days=(time2-time1)/(1000*3600*24);
        return Integer.parseInt(String.valueOf(between_days));
    }

    /***
     * 判断日期是否在间隔日期内
     * @param date1
     * @param date2
     * @param date3
     * @return
     */
    public static boolean checkBetweenDate(Date date1,Date date2,Date date3){
        long startLong=date1.getTime();
        long endLong =date2.getTime();
        long between=date3.getTime();
        if (between>=between && between<=endLong){
            return  true;
        }else {
            return  false;
        }
    }

    /**
     * 比较两个日期
     * @param strDate
     * @param endDate
     * @return
     */
    public static boolean compareDate(String strDate,String endDate){
        Date startDate= DateUtils.stringToDate(strDate, DateUtils.DATE_PATTERN);
        Date endDate1= DateUtils.stringToDate(endDate, DateUtils.DATE_PATTERN);
        return DateUtils.compareDate(startDate,endDate1) ;
    }

    /**
     * 比较两个日期大小
     * @param strdate
     * @param enddate
     * @return
     */
    public static boolean compareDate(Date strdate,Date enddate){
        boolean flag=true;
        long startTime=strdate.getTime();
        long endTime=enddate.getTime();
        if (endTime<startTime){
            flag=false;
        }

        return  flag;
    }

    /**
    * 日期加分钟
    * @Param:  * @param date
     * @param min
    * @return: java.util.Date
    * @Author: zhangjie
    * @Date: 2019/10/24 21:04
    */
    public static Date  addDateMinute(Date date,int min){
        Calendar c=Calendar.getInstance();
        c.setTime(date);
        c.add(Calendar.MINUTE, min);
        return  c.getTime();
    }
}
