package com.ekingwin.bas.cloud.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 
 * @author zhangjie
 * @date 2019/03/28
 */
public class HttpXmlClient {

    public static void post(String obj, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        // connection.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.connect();
        // POST请求
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        // 这样可以处理中文乱码问题
        out.write(obj.getBytes("UTF-8"));
        out.flush();
        out.close();

        // 读取响应
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String lines;
        StringBuffer s = new StringBuffer("");
        while ((lines = reader.readLine()) != null) {
            lines = new String(lines.getBytes(), "utf-8");
            s.append(lines);
        }
        reader.close();
        // 断开连接
        connection.disconnect();
    }

    public static String post1(String obj, String urlStr) throws Exception {
        URL url = new URL(urlStr);
        String result = "";
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(300000);
            connection.setReadTimeout(600000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            connection.connect();
            // POST请求
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            // 这样可以处理中文乱码问题
            out.write(obj.getBytes("UTF-8"));
            out.flush();
            out.close();

            // 读取响应
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String lines;
            StringBuffer s = new StringBuffer("");
            while ((lines = reader.readLine()) != null) {
                lines = new String(lines.getBytes(), "utf-8");
                s.append(lines);
            }
            reader.close();
            result = s.toString();
            return result;
        } catch (Exception e) {
            throw new Exception(e.getMessage());
        } finally {
            // 断开连接
            connection.disconnect();
        }

    }
}
