package com.ekingwin.bas.cloud.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

/**
 * 
 * @author zhangjie
 * @date 2019/04/03
 */
public class JsonStringUtils {

    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    /** 驼峰转下划线,效率比上面高 */
    public static String humpToLine2(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    /**
     * 等于
     */
    private static String EQ = "EQ";
    /**
     * 不等于
     */
    private static String NEQ = "NEQ";

    /**
     * 大于
     */
    private static String GT = "GT";

    /**
     * 大于等于
     */
    private static String GTE = "GTE";
    /**
     * 小于
     */
    private static String LT = "LT";

    /**
     * 小于等于
     */
    private static String LTE = "LTE";
    /**
     * 模糊查询
     */
    private static String LIKE = "LIKE";

    private static String NOT_LIKE = "NOT_LIKE";

    private static String STR = "String";

    private static String STRDATE = "Date";

    public static String spiltSql(String type, String key, String keyValue, String dataType) {

        String str ="";
       if (StringUtils.isNotEmpty(keyValue)){
        str = " AND ";
        if (StringUtils.isEmpty(dataType)) {
            dataType = "String";
        }
        if (STR.equals(dataType)) {
            if (EQ.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " = '" + keyValue + "' ";
            } else if (NEQ.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " != '" + keyValue + "' ";
            } else if (GT.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " > '" + keyValue + "' ";
            } else if (GTE.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " >= '" + keyValue + "' ";
            } else if (LT.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " < '" + keyValue + "' ";
            } else if (LTE.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " <= '" + keyValue + "' ";
            } else if (LIKE.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " LIKE '%" + keyValue + "%' ";
            } else if (NOT_LIKE.equals(type)) {
                str += " " + JsonStringUtils.humpToLine2(key) + " NOT LIKE '%" + keyValue + "%' ";
            }
        } else if (STRDATE.equals(dataType)) {
            if (EQ.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') = DATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d')";
            } else if (NEQ.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') != DATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d')";
            } else if (GT.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') > DATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d') ";
            } else if (GTE.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') >= DATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d') ";
            } else if (LT.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') < DATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d')";
            } else if (LTE.equals(type)) {
                str += " DATE_FORMAT(" + JsonStringUtils.humpToLine2(key) + ",'%Y-%m-%d') <= TDATE_FORMAT('" + keyValue
                    + "','%Y-%m-%d') ";
            }
        }
        }
        return str;
    }
}
