package com.ekingwin.bas.cloud.util;

import com.ekingwin.bas.cloud.infra.utils.db.PageCriteria;
import org.apache.poi.ss.formula.functions.T;

import java.util.List;
import java.util.Map;

/**
 * @date 2019/11/06
 * @author Rickie
 *
 */
 
public class PublicJsonObject {

	/**
	 * 封装json工具类
	 * @param pageCriteria 封装的data数据
	 * @return
	 */
	@SuppressWarnings({ "unused", "rawtypes" })
	private static BackResult json(PageCriteria<T> pageCriteria) {
		try {
			if (pageCriteria != null) {
				if (pageCriteria.getList() != null && !pageCriteria.getList().isEmpty()) {
					return BackResult.successResponse(200, "查询成功", pageCriteria);
				} else {
					return BackResult.successResponse(200, "查询数据为空", pageCriteria);
				}
			} else {
				return BackResult.successResponse(500, "查询失败", pageCriteria);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return BackResult.successResponse(500, "查询失败", e.getMessage());
		}
	}
	  /**
     * 封装json工具类
     * @param list 封装的data数据
     * @return
     */
    public static BackResult   jsonObject(Object list) {
        try {
            if (list!=null) {
                return BackResult.successResponse(200, "查询成功", list);
            }else{
				return BackResult.successResponse(200, "查询数据为空", list);
			}
        } catch (Exception e) {
            e.printStackTrace();
            return BackResult.successResponse(500, "查询失败", e.getMessage());
        }
    }

	  /**
     * 封装json工具类
     * @param string 封装的data数据
     * @return
     */
    public static BackResult json(String string) {
        try {
            if (string != null && string != "" ) {
                return BackResult.successResponse(200, "查询成功", string);
            } else if (string == null || string == "") {
                return BackResult.successResponse(200, "查询数据为空", string);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return BackResult.successResponse(500, "查询失败", e.getMessage());
        }
      	return BackResult.successResponse(500, "查询失败", "");
    }
    /**
     * 封装json工具类
     * @param string 封装的data数据
     * @return
     */
    public static BackResult json(List<Map<String, Object>> string) {
    	try {
    		if (string != null && string.size()>0 ) {
    			return BackResult.successResponse(200, "查询成功", string);
    		} else if (string == null || string.size()==0) {
    			return BackResult.successResponse(200, "查询数据为空", string);
    		}
    	} catch (Exception e) {
    		e.printStackTrace();
    		return BackResult.successResponse(500, "查询失败", e.getMessage());
    	}
      	return BackResult.successResponse(500, "查询失败", "");
    }
    /**
     * 封装json工具类
     * @param string 封装的data数据
     * @return
     */
    public static BackResult jsonListMapString(List<Map<String, String>> string) {
    	try {
    		if (string != null && string.size()>0 ) {
    			return BackResult.successResponse(200, "查询成功", string);
    		} else if (string == null || string.size()==0) {
    			return BackResult.successResponse(200, "查询数据为空", string);
    		}
    	} catch (Exception e) {
    		e.printStackTrace();
    		return BackResult.successResponse(500, "查询失败", e.getMessage());
    	}
      	return BackResult.successResponse(500, "查询失败", "");
    }
    /**
     * 封装json工具类
     * @param string 封装的data数据
     * @return
     */
    public  static BackResult json(boolean  string) {
    	try {
    		if(string){
				return BackResult.successResponse(200, "创建成功", string);
			}else {
				return BackResult.successResponse(200, "创建失败", string);
			}
    	} catch (Exception e) {
    		e.printStackTrace();
    		return BackResult.successResponse(500, "创建失败", e.getMessage());
    	}
    }

	/**
	 * 封装json工具类
	 * @param string 封装的data数据
	 * @return
	 */
	public  static BackResult jsonUpdate(boolean  string) {
		try {
			if(string){
				return BackResult.successResponse(200, "修改成功", string);
			}else {
				return BackResult.successResponse(200, "修改失败", string);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return BackResult.successResponse(500, "修改失败", e.getMessage());
		}
	}

	/**
	 * 封装json工具类
	 * @param string 封装的data数据
	 * @return
	 */
	public  static BackResult jsonDelete(boolean  string) {
		try {
			if(string){
				return BackResult.successResponse(200, "删除成功", string);
			}else {
				return BackResult.successResponse(200, "删除失败", string);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return BackResult.successResponse(500, "删除失败", e.getMessage());
		}
	}

	/**
	 * 封装json工具类ContentWrap对象
	 * @param string 封装的data数据
	 * @return
	 */
	public static BackResult jsonList(List string) {
		try {
			if (string != null && string.size()>0 ) {
				return BackResult.successResponse(200, "查询成功", string);
			} else if (string == null || string.size()==0) {
				return BackResult.successResponse(200, "查询数据为空", string);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return BackResult.successResponse(500, "查询失败", e.getMessage());
		}
		return BackResult.successResponse(500, "查询失败", "");
	}


	/**
	 * 封装json工具类
	 * @param map 封装的data数据
	 * @return
	 */
	public  static BackResult json(Map map) {
		try {
			if (map != null && !map.isEmpty()) {
				return BackResult.successResponse(200, "查询成功", map);
			} else if (map == null || map.size()==0) {
				return BackResult.successResponse(200, "查询数据为空", map);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return BackResult.successResponse(500, "查询失败", e.getMessage());
		}
		return BackResult.successResponse(500, "查询失败", "");
	}
}
