package com.ekingwin.bas.cloud.cart.dao.entity;

import com.ekingwin.bas.cloud.cart.dto.CartGoodsDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
@Table(name = "IP_C_CART")
public class Cart {

    private Integer id;
    @ApiModelProperty(value = "用户id",required = false)
    private String userid;
    @ApiModelProperty(value = "商品id",required = false)
    private String goodsid;
    @ApiModelProperty(value = "数量",required = false)
    private String count;
    @ApiModelProperty(value = "价格",required = false)
    private BigDecimal price;
    @ApiModelProperty(value = "物资分类",required = false)
    private String materialClassify;
    @ApiModelProperty(value = "属性组合id",required = false)
    private String attrid;
    @ApiModelProperty(value = "授权商id（供应商id）",required = false)
    private String licensor;
    @ApiModelProperty(value = "所属公司组织",required = false)
    private String companyId;
    @ApiModelProperty(value = "不含税价格",required = false)
    private String notaxPrice;
    @ApiModelProperty(value = "购物车个数",required = false)
    private String num;
    @ApiModelProperty(value = "供应商id",required = false)
    private String supplierid;
    @ApiModelProperty(value = "供应商名称",required = false)
    private String suppliername;
    /**
     * 商品信息
     */
    @ApiModelProperty(value = "商品信息",required = false)
    private Map<Object,Object> goodsMap;

    /**
     * 商品总信息
     */
    @ApiModelProperty(value = "商品总信息",required = false)
    private CartGoodsDto cartGoodsDtos;

}
