package com.ekingwin.bas.cloud.cart.dto;

import com.ekingwin.bas.cloud.dto.BasDto;
import com.ekingwin.bas.cloud.dto.IpOrderGoodDraftsDto;
import com.ekingwin.bas.cloud.dto.IpcOrderDraftsAttachmentDto;
import com.ekingwin.bas.cloud.dto.OrgInfoDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class CartOrderDto extends BasDto {
    private Integer id;
    @ApiModelProperty(value = "草稿箱id", required = false)
    private String draftsid;
    @ApiModelProperty(value = "订单名称", required = false)
    private String ordername;
    @ApiModelProperty(value = "流程编号", required = false)
    private String processnum;
    @ApiModelProperty(value = "流程主题", required = false)
    private String processtheme;
    @ApiModelProperty(value = "采购需求单号", required = false)
    private String requirementsnum;
    @ApiModelProperty(value = "EBS订单号", required = false)
    private String ponum;
    @ApiModelProperty(value = "合同号", required = false)
    private String contractnumber;
    @ApiModelProperty(value = "发货方", required = false)
    private String sender;
    @ApiModelProperty(value = "收货方", required = false)
    private String receiver;
    @ApiModelProperty(value = "收货公司", required = false)
    private String deliverycompanyname;
    @ApiModelProperty(value = "收货地址", required = false)
    private String deliveryaddress;
    @ApiModelProperty(value = "收货部门", required = false)
    private String receivedept;
    @ApiModelProperty(value = "收款账号", required = false)
    private String receivablesaccount;
    @ApiModelProperty(value = "订单金额", required = false)
    private String orderprice;
    @ApiModelProperty(value = "录入人", required = false)
    private String inputperson;
    @ApiModelProperty(value = "录入日期", required = false)
    private String inputdate;
    @ApiModelProperty(value = "票据信息id", required = false)
    private String billid;
    private String endsenddate;
    @ApiModelProperty(value = "是否为京东采购", required = false)
    private String isjdpurchase;
    @ApiModelProperty(value = "京东退回是否删除", required = false)
    private String isjdRetrun;
    @ApiModelProperty(value = "审批状态", required = false)
    private String state;
    private String seq;
    @ApiModelProperty(value = "上架使用界面", required = false)
    private String surfacetype;
    @ApiModelProperty(value = "订单类型，默认FBN", required = false)
    private String ordertype;
    @ApiModelProperty(value = "采购员", required = false)
    private String buyer;
    @ApiModelProperty(value = "采购组织", required = false)
    private String purchasingorganization;
    @ApiModelProperty(value = "采购组", required = false)
    private String purchasinggroup;
    @ApiModelProperty(value = "本位币合计金额（含税）", required = false)
    private String smallamounttax;
    @ApiModelProperty(value = "本位币合计金额（不含税）", required = false)
    private String smallamount;
    @ApiModelProperty(value = "人民币合计金额（含税）", required = false)
    private String rmballamounttax;
    @ApiModelProperty(value = "人民币合计金额（不含税）", required = false)
    private String rmballamount;
    @ApiModelProperty(value = "总价（含税）", required = false)
    private String totalhsprice;
    @ApiModelProperty(value = "税率", required = false)
    private String taxrate;
    @ApiModelProperty(value = "不含税价", required = false)
    private String totalbhsprice;
    @ApiModelProperty(value = "币种默认CNY", required = false)
    private String currency;
    @ApiModelProperty(value = "税码", required = false)
    private String taxcode;
    @ApiModelProperty(value = "大区id", required = false)
    private String largeareaid;
    @ApiModelProperty(value = "大区名称", required = false)
    private String largeareaname;
    @ApiModelProperty(value = "所属公司名称", required = false)
    private String companyname;
    @ApiModelProperty(value = "供应商", required = false)
    private String supplier;
    @ApiModelProperty(value = "凭证日期", required = false)
    private String documentdate;
    @ApiModelProperty(value = "收件人地址", required = false)
    private String addressee;
    @ApiModelProperty(value = "手机号", required = false)
    private String mobile;
    @ApiModelProperty(value = "邮箱", required = false)
    private String email;
    @ApiModelProperty(value = "所在地区的京东CODE", required = false)
    private String locationcode;
    @ApiModelProperty(value = "所在地区", required = false)
    private String locationname;
    @ApiModelProperty(value = "详细地址", required = false)
    private String detailedaddress;
    @ApiModelProperty(value = "采购原因", required = false)
    private String purchasingreason;
    @ApiModelProperty(value = "开票地址编码", required = false)
    private String billingaddresscode;
    @ApiModelProperty(value = "开票地址", required = false)
    private String billingaddress;

    private String factorycode;
    @ApiModelProperty(value = "工厂", required = false)
    private String factory;
    @ApiModelProperty(value = "订单状态", required = false)
    private String orderstate;
    @ApiModelProperty(value = "采购组织", required = false)
    private String purchaseorg;
    @ApiModelProperty(value = "采购组", required = false)
    private String purchasegroup;
    @ApiModelProperty(value = "采购原因", required = false)
    private String purchasereason;
    @ApiModelProperty(value = "商品其他要求", required = false)
    private String goodsotherrequire;

    private String bpmurl;
    @ApiModelProperty(value = "FBC详情链接", required = false)
    private String detaillink;
    @ApiModelProperty(value = "是否草稿箱:Y/N", required = false)
    private String isdrafts;
    @ApiModelProperty(value = "BPMID", required = false)
    private String bpmid;
    @ApiModelProperty(value = "京东下单失败原因", required = false)
    private String resultmessage;
    @ApiModelProperty(value = "订单审批完成时间", required = false)
    private String appproedate;
    @ApiModelProperty(value = "类型", required = false)
    private String materialclassify;
    @ApiModelProperty(value = "所属部门编号", required = false)
    private String deptid;
    @ApiModelProperty(value = "所属部门名称", required = false)
    private String deptname;
    @ApiModelProperty(value = "所属岗位编号", required = false)
    private String postionid;
    @ApiModelProperty(value = "所在岗位名称", required = false)
    private String postionname;
    @ApiModelProperty(value = "开票方式名称", required = false)
    private String invoicetypename;
    @ApiModelProperty(value = "开票状态 1：普票  2：增票", required = false)
    private String invoicetype;
    @ApiModelProperty(value = "订单采购类型(京东/非京东", required = false)
    private String purchasetype;
    @ApiModelProperty(value = "立项报告编号", required = false)
    private String liji_report_num;
    @ApiModelProperty(value = "立项报告名称", required = false)
    private String liji_report_name;
    @ApiModelProperty(value = "预算总额", required = false)
    private String yusuan_amount;
    @ApiModelProperty(value = "商品信息", required = false)
    private List<IpOrderGoodDraftsDto> goods;
    @ApiModelProperty(value = "附件信息", required = false)
    private List<IpcOrderDraftsAttachmentDto> attachments;
    @ApiModelProperty(value = "基本组织人员信息", required = false)
    private List<OrgInfoDto> orgInfoDtos;
}
