package com.ekingwin.bas.cloud.cart.service;

import com.ekingwin.bas.cloud.cart.dao.entity.Cart;
import com.ekingwin.bas.cloud.cart.dto.CartDto;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.cart.dto.IdleGoodsListDto;
import com.ekingwin.bas.cloud.util.Result;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface IpCartService {
    Result saveCart(CartDto cartDto);

    Result checkGoodsStock(String goodsId, String count, BigDecimal ocount, String attrid);

    List<Cart> cartList(CartDto cartDto)throws Exception;

    Map<String, List<Cart>> cartList1(CartDto cartDto)throws Exception;
    Integer cartCount(String userid)throws Exception;

    BaseResult deletecart(String ids);

    /**
     * 批量删除购物车
     * @param ids
     * @return
     */
    BaseResult batchRemoveCart(String ids);
    /**
     * 购物车页面结算
     * @param goodsListDto
     * @return
     */
    Result cartAdjustment(List<IdleGoodsListDto> goodsListDto);

    /**
     * 购物车页面数量的增减
     * @param goodsListDto
     * @return
     */
    Result cartAddCount(IdleGoodsListDto goodsListDto);
}
