package com.ekingwin.bas.cloud.cart.web;

import com.ekingwin.bas.cloud.cart.dao.entity.Cart;
import com.ekingwin.bas.cloud.cart.dto.CartDto;
import com.ekingwin.bas.cloud.cart.dto.IdleGoodsListDto;
import com.ekingwin.bas.cloud.cart.service.IpCartService;
import com.ekingwin.bas.cloud.infra.dto.BaseResult;
import com.ekingwin.bas.cloud.infra.utils.common.ResultUtils;
import com.ekingwin.bas.cloud.service.IpcCartService;
import com.ekingwin.bas.cloud.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/cart/")
@Api(tags = "供应商商品详情页", description = "供应商商品详情页", value = "供应商商品详情页")
public class CartController {

    @Autowired
    private IpCartService ipCartService;
    @Autowired
    private IpcCartService ipcCartService;
    @PostMapping("/saveCart")
    @ApiOperation(value = "加入购物车", notes = "加入购物车")
    public Result saveCar(@RequestBody CartDto cartDto) throws Exception{
        return ipCartService.saveCart(cartDto);

    }
    //    @PostMapping("/saveCar")
//    @ApiOperation(value = "加入购物车", notes = "加入购物车")
//    public Result saveCar(@RequestBody IpcCart2Dto ipcCartDto) throws Exception{
//        ipcCartService.saveCar(ipcCartDto);
//        return Result.ok();
//    }
    @PostMapping("/cartList")
    @ApiOperation(value = "购物车列表", notes = "购物车列表")
    public BaseResult cartList(@RequestBody CartDto cartDto) throws Exception{
        List<Cart> list= ipCartService.cartList(cartDto);
        return ResultUtils.build(list);
    }
    @PostMapping("/cartList1")
    @ApiOperation(value = "按供应商划分购物车列表", notes = "购物车列表")
    public BaseResult cartList1(@RequestBody CartDto cartDto) throws Exception{
        Map<String, List<Cart>> map= ipCartService.cartList1(cartDto);
        return ResultUtils.build(map);
    }
    @GetMapping("/cartCount")
    @ApiOperation(value = "购物车数量", notes = "购物车数量")
    public BaseResult cartCount(@RequestParam String userid) throws Exception{
        Integer count= ipCartService.cartCount(userid);
        return ResultUtils.build(count);
    }

    @GetMapping("/deletecart")
    @ApiOperation(value = "提交订单成功，清理购物车中信息", notes = "提交订单成功，清理购物车中信息")
    public BaseResult deletecart(@RequestParam String ids) throws Exception{
        return ipCartService.deletecart(ids);
    }

    @GetMapping("/batchRemoveCart")
    @ApiOperation(value = "批量删除购物车", notes = "批量删除购物车")
    public BaseResult batchRemoveCart(@RequestParam String ids) throws Exception{
        return ipCartService.batchRemoveCart(ids);
    }


    @PostMapping("/cartAdjustment")
    @ApiOperation(value = "购物车页面结算", notes = "购物车页面结算")
    public Result cartAdjustment(@RequestBody List<IdleGoodsListDto> goodsListDto) throws Exception{
        return ipCartService.cartAdjustment(goodsListDto);
    }
    @PostMapping("/cartAddCount")
    @ApiOperation(value = "购物车页面数量的增减", notes = "购物车页面数量的增减")
    public Result cartAddCount(@RequestBody IdleGoodsListDto goodsListDto) throws Exception{
        return ipCartService.cartAddCount(goodsListDto);
    }


}
