package com.ekingwin.bas.cloud.config;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-24 11:07
 **/
@Configuration
@ConfigurationProperties(prefix = "rabbitmq.exchange")
@Data
@ApiModel("订单支付Rabbit配置文件")
public class RabbitExchangeConfig {

    @ApiModelProperty("订单支付")
    private String payment;

    @ApiModelProperty("物流")
    private String logic;


    @ApiModelProperty("退货")
    private String rejected;

    @ApiModelProperty("發票")
    private String ticket;

    @ApiModelProperty("商品")
    private String goods;

    @ApiModelProperty("取消订单")
    private String cancel;

    @ApiModelProperty("sap同步付款")
    private String sappayment;

    @ApiModelProperty("sap同步发票")
    private String sapinvoice;

    @ApiModelProperty("sap推送数据到运营平台")
    private String monitororder;

    @ApiModelProperty("同步发货单到sap")
    private String saporderreceiver;


    /**
     *  sap材料明细
     */
    private String sapgoods;

}
