package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderAddressDto;
import com.ekingwin.bas.cloud.entity.IpCustAddress;
import com.ekingwin.bas.cloud.vo.IpCustOrderAddressVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import tk.mybatis.mapper.common.BaseMapper;

import java.util.List;

/**
 * @ClassName :
 * @description:
 * @author: zhangjie
 * @create: 2019-10-25 13:38
 **/
@Repository
public interface IpCustAddressMapper  extends BaseMapper<IpCustAddress> {


    /**
    * 修改地址为默认
    * @Param:  * @param isDefault
     * @param userid
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 14:07
    */
    int updateAddressDefault(@Param(value = "isDefault") String isDefault,
                             @Param(value = "userid")String userid);



    /**
    * 查询所有的地址
    * @Param:  * @param isDefault
     * @param
    * @return: java.util.List<com.ekingwin.bas.cloud.entity.IpCustAddress>
    * @Author: zhangjie
    * @Date: 2019/10/25 14:12
    */
    List<IpCustOrderAddressVo> getCustAddressList(IpOrderAddressDto ipOrderAddressDto);



    /**
    * 删除地址
    * @Param:  * @param id
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 14:40
    */
    int updateAddressDelete(Long id);

    /**
    * 修改地址为默认
    * @Param:  * @param id
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 14:42
    */
    int updateAddressDefaultById(Long id);

    /**
    * 修改
    * @Param:  * @param ipCustAddress
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/25 15:57
    */
    int updateCustAddress(IpCustAddress ipCustAddress);
}
