package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpContractGoodDto;
import com.ekingwin.bas.cloud.dto.IpGoodsContractDto;
import com.ekingwin.bas.cloud.vo.IpContractGoodsVo;
import com.ekingwin.bas.cloud.vo.IpGoodsContractVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: rcworkspace
 * @description:
 * @author: zhangjie
 * @create: 2019-06-30 11:26
 **/
@Repository
public interface IpGoodContractMapper {

    /**
     * 根据项目编号和商品编码获取合同消息
     * @param ipGoodsContractDto
     * @return
     */
    List<IpGoodsContractVo> selectGoodContract(IpGoodsContractDto ipGoodsContractDto);

    /**
     * 获取合同商品信息
     * @param ipContractGoodDto
     * @return
     */
    List<IpContractGoodsVo> getContractGoods(IpContractGoodDto ipContractGoodDto);

    /**
     * 扣减合同商品数量
     * @param ipContractGoodDto
     * @return
     */
    int updateContractGoodsNum(IpContractGoodDto ipContractGoodDto);
}
