package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.Documentation;
import com.ekingwin.bas.cloud.dto.IpInvoiceDto;
import com.ekingwin.bas.cloud.dto.IpInvoicePageDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapInvoiceReturnDto;
import com.ekingwin.bas.cloud.entity.IpInvoice;
import com.ekingwin.bas.cloud.vo.IpInvoiceDetailVo;
import com.ekingwin.bas.cloud.vo.IpInvoiceLsitExcelVo;
import com.ekingwin.bas.cloud.vo.IpInvoiceLsitVo;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpInvoiceMapper {

    /**
     * 发票记录列表
     * @param invoicePageDto
     * @return
     */
    List<IpInvoiceLsitVo> selectInvoiceList(IpInvoicePageDto invoicePageDto);

    /**
     * 发票记录详情
     * @param id
     * @return
     */
    IpInvoiceDto getInvoice(Long id);

    /**
     * 电商单据号 查询发票记录
     * @param paymentnum 电商单据号
     * @return
     */
    IpInvoiceDto selectInvoiceId(String paymentnum);

    /**
     * 获取附件
     * @param ids
     * @return
     */
    List<Documentation> getFiles(List ids);


    /**
     * 新增 发票记录
     * @param ipInvoice
     */
    void saveIpInvoice(IpInvoice ipInvoice);

    /**
     * 修改 发票记录
     * @param ipInvoice
     */
    void updateIpInvoice(IpInvoice ipInvoice);


    /**
     * 发票记录列表Excel导出
     * @param ipInvoicePageDto
     * @return
     */
    List<IpInvoiceLsitExcelVo> getExcel(IpInvoicePageDto ipInvoicePageDto);

    /**
     * 零星采购
     * @param purchasesDto
     * @return
     */
    List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto);

    /**
     * 工程采购
     * @param purchasesDto
     * @return
     */
    IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto);

    /**
     * 工程采购 明细
     * @param purchasesDto
     * @return
     */
    List<IpInvoiceDetailVo> selectEngineeringDetail(IpPurchasesDto purchasesDto);


    /**
     * SAP 返回值 修改发票状态
     * @param payableDto
     */
    void updateInvoice(SapInvoiceReturnDto payableDto);
}
