package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderDeliverDetailDto;
import com.ekingwin.bas.cloud.dto.IpOrderGoodsStatusDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiveGoodDto;
import com.ekingwin.bas.cloud.entity.IpOrderDeliverGood;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverGoodVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderDeliverGoodMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpOrderDeliverGood record);

    int insertSelective(IpOrderDeliverGood record);

    IpOrderDeliverGood selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderDeliverGood record);

    int updateByPrimaryKey(IpOrderDeliverGood record);

    /**
     * 删除商品信息
     * @return
     */
    int deleteByDeliverId(Long deliverId);


    /**
     * 获取商品信息
     * @param ipOrderDeliverDetailDto1
     * @return
     */
    List<IpOrderDeliverGoodVo> getOrderDeliverGood(IpOrderDeliverDetailDto ipOrderDeliverDetailDto1);

    /**
     * 修改商品的数量
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus(IpOrderGoodsStatusDto  ipOrderGoodsStatusDto);

    /**
    * 修改个人发货单商品状态与数量
    * @Param:  * @param list
     * @param status
    * @return: int
    */
    int updateGrDeliverGoodsStatus(@Param(value = "list") List<IpOrderReceiveGoodDto> list,@Param(value = "status") String status);

    /**
    * 根据发货单id修改商品的状态
    * @Param:  * @param status
     * @param deliverId
    * @return: int
    */
    int updateStatusByDeliverId(@Param(value = "status") String status,@Param(value="deliverId") Long  deliverId);
}