package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderDeliverListDto;
import com.ekingwin.bas.cloud.dto.IpOrderDeliverSearchDto;
import com.ekingwin.bas.cloud.dto.IpOrderLogisticsSearchDto;
import com.ekingwin.bas.cloud.entity.IpOrderDeliver;
import com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo;
import com.ekingwin.bas.cloud.vo.IpOrderDeliverVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderDeliverMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpOrderDeliver record);

    int insertSelective(IpOrderDeliver record);

    IpOrderDeliver selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderDeliver record);

    int updateByPrimaryKey(IpOrderDeliver record);


    /**
     * 获取发货单号
     * @return
     */
    String getDeliverNum();

    /**
     * 移动端查询发货单数据
     * @param ipOrderDeliverListDto
     * @return
     */
    List<IpOrderDeliverVo> getAllOrderDeliver(IpOrderDeliverListDto ipOrderDeliverListDto);

    /**
     * pc端查询送货单列表
     * @param ipOrderDeliverListDto
     * @return
     */
    List<IpOrderDeliverVo> getAllOrderDeliverNoSupplierNoMobile(IpOrderDeliverListDto ipOrderDeliverListDto);

    /**
     * 查询收货单数据
     * @param ipOrderDeliverListDto
     * @return
     */
    List<IpOrderDeliverVo> getAllOrderDeliverNoSupplier(IpOrderDeliverListDto ipOrderDeliverListDto);
    /**
     * 根据单号获取发货单详情
     * @param ipOrderDeliverSearchDto
     * @return
     */
    IpOrderDeliverVo getOrderDeliverById(IpOrderDeliverSearchDto ipOrderDeliverSearchDto);

    /**
     *根据订单号获取物流信息
     * @param ipOrderLogisticsSearchDto
     * @return
     */
    List<IpOrderDeliverVo> getOrderDeliverByOrderNum(IpOrderLogisticsSearchDto ipOrderLogisticsSearchDto);

    /**
     * 修改发货单状态
     * @param status
     * @param id
     * @return
     */
    int updateStatus(@Param(value = "status") String status,@Param(value="id") Long  id);


    /**
    * 获取物流信息
    * @Param:  * @param couriernumber
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpDeliverLogisticsVo>
    * @Author: zhangjie
    * @Date: 2019/10/28 17:12
    */
    List<IpDeliverLogisticsVo> getLogisticsByNum(String couriernumber);
}