package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpCarSearchDto;
import com.ekingwin.bas.cloud.dto.IpOrderDetailDto;
import com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author Jie
 * @date 2019-06-30
 */
@Repository
public interface IpOrderMapper {


    /**
     * 根据商品ID查询购物车1商品详情
     * @param ipOrderDetailDto
     * @return
     */
    List<IpOrderGoodsDetailVo> getOrderGoodsDetail(IpOrderDetailDto ipOrderDetailDto);


    /**
     *查询购物车的商品
     * @param ipCarSearchDto
     * @return
     */
    List<IpOrderGoodsDetailVo> getCarGoodsDetail(IpCarSearchDto ipCarSearchDto);

    /**
     * 查询购物车失效商品
     * @param ipCarSearchDto
     * @return
     */
    List<IpOrderGoodsDetailVo>  getCarGoodsDetailNoEffect(IpCarSearchDto ipCarSearchDto);


    /**
     * 根据草稿箱ID获取商品信息
     * @param ipOrderDetailDto
     * @return
     */
    List<IpOrderGoodsDetailVo>  getOderGoodsDraft(IpOrderDetailDto ipOrderDetailDto);

    /**
     * 根据订单ID获取商品信息
     * @param ipOrderDetailDto
     * @return
     */
    List<IpOrderGoodsDetailVo> getOderGoods(IpOrderDetailDto ipOrderDetailDto);

    /**
     * 获取订单号
     * @return
     */
    String getOrderNum();
}
