package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderReceiveGoodDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiverSearchDto;
import com.ekingwin.bas.cloud.entity.IpOrderReceiveGoods;
import com.ekingwin.bas.cloud.vo.IpOrderReceiverGoodVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderReceiveGoodsMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpOrderReceiveGoods record);

    int insertSelective(IpOrderReceiveGoods record);

    IpOrderReceiveGoods selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderReceiveGoods record);

    int updateByPrimaryKey(IpOrderReceiveGoods record);

    /**
     * 删除收货商品信息
     * @param receiverId
     * @return
     */
    int deleteByReceiverId(Long receiverId);


    /**
     * 获取所有的审批人
     * @param list
     * @return
     */
    List<String> getAllGoodsReceiverNum(List<IpOrderReceiveGoodDto> list);


    /**
     * 查询收货商品
     * @param ipOrderReceiverSearchDto
     * @return
     */
    List<IpOrderReceiverGoodVo> getOrderReceiverGood(IpOrderReceiverSearchDto ipOrderReceiverSearchDto);
}