package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderReceiverDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiverSearchDto;
import com.ekingwin.bas.cloud.dto.tick.SettlementDetailsReq;
import com.ekingwin.bas.cloud.dto.tick.SettlementMainReq;
import com.ekingwin.bas.cloud.entity.IpOrderReceive;
import com.ekingwin.bas.cloud.vo.IpOrderReceiverVo;
import com.ekingwin.bas.cloud.vo.SapReceiverVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderReceiveMapper {
    int deleteByPrimaryKey(Long id);


    int insertSelective(IpOrderReceive record);

    IpOrderReceive selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderReceive record);

    int updateByPrimaryKey(IpOrderReceive record);

    /**
     * 获取收货单单号
     * @return
     */
    String getReceiverNum();

    /**
     * 根据流程实例号获取数据
     * @param instid
     * @return
     */
    IpOrderReceive selectByInstid(String instid);

    /**
     * 送货单详情
     * @param ipOrderReceiverSearchDto
     * @return
     */
    IpOrderReceiverVo selectByReceiverId(IpOrderReceiverSearchDto ipOrderReceiverSearchDto);


    /**
     * 根据送货单ID获取收货单信息
     * @param deliverId
     * @return
     */
    List<IpOrderReceive> selectByDeliverId(Long deliverId);


    /**
    * 获取发票主信息
    * @Param:  * @param ipOrderReceiverDto
    * @return: java.util.List<com.ekingwin.bas.cloud.dto.tick.SettlementMainReq>
    * @Author: zhangjie
    * @Date: 2019/10/31 16:25
    */
    List<SettlementMainReq> getInvoiceMain(IpOrderReceiverDto ipOrderReceiverDto);

    /**
    * 开票明细
    * @Param:  * @param ipOrderReceiverDto
    * @return: java.util.List<com.ekingwin.bas.cloud.dto.tick.SettlementDetailsReq>
    * @Author: zhangjie
    * @Date: 2019/10/31 16:37
    */
    List<SettlementDetailsReq> getOrderGoodsInvoice(IpOrderReceiverDto ipOrderReceiverDto);

    /**
     * 获取sap数据
     * @param receiverId
     * @return
     */
    List<SapReceiverVo> getSapReceiverNum(Long receiverId);
}