package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderReconciliationRecordPageDto;
import com.ekingwin.bas.cloud.dto.IpOrderReconciliationSupplementDto;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationRecord;
import com.ekingwin.bas.cloud.vo.IpOrderReconciliationProjectExcelVo;
import com.ekingwin.bas.cloud.vo.IpOrderReconciliationRetailExcelVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @ClassName: IpOrderReconciliationRecordMapper
 * @Author: liujunfeng
 * @Date: 2019/11/28 15:06
 * @description:
 */
@Repository
public interface IpOrderReconciliationRecordMapper {

    /**
     * 新增对账单记录 时查询补全相关字段
     * @param orderGoodsId
     * @return
     */
    IpOrderReconciliationSupplementDto selectSupplement(Long orderGoodsId);

    /**
     * 查询对账单列表
     * @param recordPageDto
     * @return
     * @throws Exception
     */
    List<IpOrderReconciliationRecord> selectReconciliationRecordList(IpOrderReconciliationRecordPageDto recordPageDto)throws Exception;

    /**
     * 新增对账单记录
     * @param reconciliationRecord
     */
    void saveReconciliationRecord(IpOrderReconciliationRecord reconciliationRecord);

    /**
     * 修改对账单记录
     * @param reconciliationRecord
     */
    void updateReconciliationRecord(IpOrderReconciliationRecord reconciliationRecord);


    /**
     * 确认对账单
     * @param orderType
     */
    void updateReconciliationOrderStatus(String orderType);

    /**
     * 查询未对账数据
     * @param orderType
     * @return
     * @throws Exception
     */
    List<IpOrderReconciliationRecord> selectReconciliationRecord(String orderType)throws Exception;


    /**
     * 零售对账单列表 Excel导出
     * @param ipOrderReconciliationRecordPageDto
     * @return
     */
    List<IpOrderReconciliationRetailExcelVo> getExcelRetail(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto);

    /**
     * 项目对账单列表 Excel导出
     * @param ipOrderReconciliationRecordPageDto
     * @return
     */
    List<IpOrderReconciliationProjectExcelVo> getExcelProject(IpOrderReconciliationRecordPageDto ipOrderReconciliationRecordPageDto);
}
