package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.entity.IpOrderReconciliationRecord;
import com.ekingwin.bas.cloud.entity.IpOrderReconciliationSummary;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * @ClassName: IpOrderReconciliationSummaryDto
 * @Author: liujunfeng
 * @Date: 2019/12/12 16:51
 * @description:
 */
@Repository
public interface IpOrderReconciliationSummaryMapper {

    /**
     * XM合同编码 商品编码 查询是否有汇总的商品信息
     * @param record
     * @return
     */
    IpOrderReconciliationSummary selectReconciliationSummary(IpOrderReconciliationRecord record);

    /**
     * 查询是否有汇总的商品信息
     * @param goodsCode 商品编码
     * @param contractCode XM合同编码
     * @return
     */
    IpOrderReconciliationSummary selectReconciliationGoodsCode(@Param("goodsCode")String goodsCode,
                                                               @Param("contractCode")String contractCode);

    /**
     * 新增汇总
     * @param summary
     * @return
     */
    Long saveReconciliationSummary(IpOrderReconciliationSummary summary);

    /**
     * 修改汇总
     * @param summary
     */
    void updateReconciliationSummary(IpOrderReconciliationSummary summary);

    /**
     * 查询付款申请
     * @param payano 付款申请单号
     * @return
     */
    String selectcontractCode(String payano);


}
