package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderRejectSearchDto;
import com.ekingwin.bas.cloud.entity.IpOrderRejectedEntity;
import com.ekingwin.bas.cloud.vo.IpOrderRejectedVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderRejectedEntityMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(IpOrderRejectedEntity record);

    IpOrderRejectedEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderRejectedEntity record);

    /**
    * @Param:  * @param
    * @return: java.lang.String
    * @Author: zhangjie
    */
    String getRejectCode();

    /**
    * 查询退货单列表
    * @Param:  * @param ipOrderRejectSearchDto
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpOrderRejectedVo>
    * @Author: zhangjie
    * @Date: 2019/10/16 17:51
    */
    List<IpOrderRejectedVo> getOrderRejectedListByUserId(IpOrderRejectSearchDto ipOrderRejectSearchDto);

    List<IpOrderRejectedVo> getOrderRejectedListBySupplierId(IpOrderRejectSearchDto ipOrderRejectSearchDto);
    /**
    * 根据退货单ID获取详情
    * @Param:  * @param rejectedId
    * @return: com.ekingwin.bas.cloud.vo.IpOrderRejectedVo
    * @Author: zhangjie
    * @Date: 2019/10/28 17:54
    */
    IpOrderRejectedVo getOrderRejectedDetail(String rejectedId);
}