package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderRejectSearchDto;
import com.ekingwin.bas.cloud.entity.IpOrderRejectedGoodsEntity;
import com.ekingwin.bas.cloud.vo.IpOrderRejectedGoodsVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpOrderRejectedGoodsEntityMapper {
    int deleteByPrimaryKey(Long id);

    int insertSelective(IpOrderRejectedGoodsEntity record);

    IpOrderRejectedGoodsEntity selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpOrderRejectedGoodsEntity record);


    /**
    * 修改商品的状态
    * @Param:  * @param orderGoodsId
     * @param status
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/26 11:05
    */
    int updateOrderGoodsStatus(@Param(value = "orderGoodsId") Long orderGoodsId,
                               @Param(value = "status") String status);


    /**
    * 查询退货商品
    * @Param:  * @param rejectId
    * @return: java.util.List<com.ekingwin.bas.cloud.vo.IpOrderRejectedGoodsVo>
    * @Author: zhangjie
    * @Date: 2019/10/26 14:29
    */
    List<IpOrderRejectedGoodsVo> getOrderRejectGood(IpOrderRejectSearchDto ipOrderRejectSearchDto);


    int updateGoodsStatusByRejectId(@Param(value = "rejectedId") Long rejectedId,
                                    @Param(value = "status") String status);
}