package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.vo.IpOrderSupplierHomeDayVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

@Repository
public interface IpOrderSupplerHomeMapper {


    /**
     * 获取总销售额
     * @param supplierid
     * @return
     */
    BigDecimal getSupplierTotal(String supplierid);


    /**
     * 获取当日订单总额
     * @param supplierid
     * @return
     */
    BigDecimal getSupplierTodayTotal(String supplierid);

    /**
     * 获取当日订单数
     * @param supplierid
     * @return
     */
    Integer getSupplierTodayCount(String supplierid);

    /**
     * 待发货订单数
     * @param supplierid
     * @return
     */
    Integer getSupplierNoDeliverCount(String supplierid);


    /**
     * 已收货订单数
     * @param supplierid
     * @return
     */
    Integer getSupplierDeliverCount(String supplierid);

    /**
     * 获取供应商首页七日数据
     * @param supplierid
     * @return
     */
    List<IpOrderSupplierHomeDayVo> getSupplierDay(String supplierid);

    /**
     * 获取供应商上传商品数
     * @param supplierid
     * @return
     */
    Integer getUploadGoodsCount(@Param(value = "supplierid") String supplierid);
}
