package com.ekingwin.bas.cloud.dao;


import com.ekingwin.bas.cloud.dto.IpPaymentDetailDto;
import com.ekingwin.bas.cloud.entity.IpPaymentDetail;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpPaymentDetailMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpPaymentDetail record);

    int insertSelective(IpPaymentDetail record);

    IpPaymentDetail selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpPaymentDetail record);


    int updateByPrimaryKey(IpPaymentDetail record);

    void deletePaymentDetail(Long paymentId);

    void savePaymentDetail(IpPaymentDetail ipPaymentDetail);


    /**
     * 修改 订单对账 状态
     * @param recordId
     */
    void updateReconciliationRecordType(Long recordId);

    List<IpPaymentDetail> selectPaymentDetail(Long id);

    String selectcontractCode(Long id);

    /**
     * 查询付款单详细信息 — 付款商品明细
     * @param id
     * @return
     */
    List<IpPaymentDetailDto> selectPaymentDetailDto(Long id);


    /**
     * 查询本次付款申请
     * @param applyForNum 申请单号
     * @param goodsCode 商品编码
     * @return 申请的数量
     */
    IpPaymentDetailDto selectPaymentDetailNumber(@Param(value = "applyForNum")String applyForNum,@Param(value = "goodsCode") String goodsCode);





}