package com.ekingwin.bas.cloud.dao;


import com.ekingwin.bas.cloud.dto.Documentation;
import com.ekingwin.bas.cloud.dto.IpPaymentDto;
import com.ekingwin.bas.cloud.dto.IpPaymentPageDto;
import com.ekingwin.bas.cloud.dto.sapmessage.SapPaymentReturnDto;
import com.ekingwin.bas.cloud.entity.IpPayment;
import com.ekingwin.bas.cloud.vo.IpPaymentExcelVo;
import com.ekingwin.bas.cloud.vo.IpPaymentVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpPaymentMapper {

    /**
     * 获取 付款单列表信息
     * @param ipPaymentPageDto
     * @return
     */
    List<IpPaymentVo>getPaymentInfo(IpPaymentPageDto ipPaymentPageDto);

    /**
     * 新增 付款单详细信息
     * @param ipPayment
     */
    void saveIpPayment(IpPayment ipPayment);

    /**
     * 更新 付款单详细信息
     * @param ipPayment
     */
    void updateIpPayment(IpPayment ipPayment);

    /**
     * 查询付款单详细信息
     * @param id
     * @return
     */
    IpPaymentDto getPayment(Long id);

    /**
     * 查询付款单详细信息 — 附件信息
     * @param ids
     * @return
     */
    List<Documentation> getFiles( List ids);

    /**
     * 付款单信息 Excel导出
     * @param ipPaymentPageDto
     * @return
     */
    List<IpPaymentExcelVo> getExcel(IpPaymentPageDto ipPaymentPageDto);


    /**
     * SAP返回付款申请(修改后)更改 付款申请状态
     * @param paymentReturnDto
     */
    void updatePaymentStart(SapPaymentReturnDto paymentReturnDto);

    /**
     * 查询付款单
     * @param paymentno 电商付款申请单号
     * @return
     */
    Long selectPaymentId(String paymentno);

}