package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpPaymentPayInfoDto;
import com.ekingwin.bas.cloud.dto.IpPurchasesDto;
import com.ekingwin.bas.cloud.vo.IpPaymentApplyVo;
import com.ekingwin.bas.cloud.vo.IpPaymentContractVo;
import com.ekingwin.bas.cloud.vo.IpPaymentDetailVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpPaymentPayInfoMapper {

    /**
     * 查询SAP推送的付款信息
     * @param applyForNum
     * @return
     */
    List<IpPaymentPayInfoDto> selectInvoiceList(String applyForNum);

    /**
     * 合同选择
     * @param payInfoDto
     * @return
     */
    List<IpPaymentContractVo> getContractChoice(IpPaymentPayInfoDto payInfoDto);

    /**
     * 对账单选择
     * @param payInfoDto
     * @return
     */
    List<String> getReconciliationChoice(IpPaymentPayInfoDto payInfoDto);


    /**
     * 零星采购
     * @param purchasesDto
     * @return
     */
    List<IpPaymentApplyVo> getRetailPurchasesList(IpPurchasesDto purchasesDto);

    /**
     * 工程采购
     * @param purchasesDto
     * @return
     */
    IpPaymentApplyVo getEngineeringPurchasesList(IpPurchasesDto purchasesDto);

    /**
     * 工程采购 致融对供应商的价格获取
     * @param purchasesDto
     * @return
     */
    IpPaymentApplyVo getEngineeringPurchasesListHb(IpPurchasesDto purchasesDto);

    /**
     * 工程采购 明细
     * @param purchasesDto
     * @return
     */
    List<IpPaymentDetailVo> getEngineeringDetail(IpPurchasesDto purchasesDto);

}