package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.BasePageDto;
import com.ekingwin.bas.cloud.dto.IpProjectSearchDto;
import com.ekingwin.bas.cloud.entity.IpProject;
import com.ekingwin.bas.cloud.vo.IpProjectStagesUserVo;
import com.ekingwin.bas.cloud.vo.IpProjectStagesVo;
import com.ekingwin.bas.cloud.vo.IpProjectVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpProjectMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpProject record);

    int insertSelective(IpProject record);

    IpProject selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpProject record);

    int updateByPrimaryKey(IpProject record);

    /**
     * 获取所有的项目
     * @return
     */
    List<IpProjectVo> getAllProject(IpProjectSearchDto ipProjectSearchDto);

    /**
     * 根据项目获取分期
     * @param ipProjectSearchDto
     * @return
     */
    List<IpProjectStagesVo>  getStages(IpProjectSearchDto ipProjectSearchDto);

    /**
     * 查询收货人
     * @param ipProjectSearchDto
     * @return
     */
    List<IpProjectStagesUserVo> getStagesUser(IpProjectSearchDto ipProjectSearchDto);
}