package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpProjectUserDto;
import com.ekingwin.bas.cloud.entity.IpProjectUser;
import com.ekingwin.bas.cloud.vo.IpProjectUserVo;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface IpProjectUserMapper {
    int deleteByPrimaryKey(Long id);

    int insert(IpProjectUser record);

    int insertSelective(IpProjectUser record);

    IpProjectUser selectByPrimaryKey(Long id);


    /**
     * 分期编码查询 启用状态下 是否已配置 收货方管理
     * @param stagesCode
     * @return
     */
    List<IpProjectUser> selectProjectStagesCode(String stagesCode);

    int updateByPrimaryKeySelective(IpProjectUser record);

    int updateByPrimaryKey(IpProjectUser record);

    List<IpProjectUserVo> getProjectReceiverPage(IpProjectUserDto ipProjectUserDto);


    /**
     * 获取岗位信息
     * @param userId
     * @return
     */
    List<String> getEmployUser(String userId);

    /**
     * 获取所有的岗位
     * @param orgid
     * @return
     */
    String getTree(String orgid);

    /**
     * 获取所有父岗位
     * @param orgid
     * @return
     */
    String getParentTree(String orgid);
}