package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.cart.dao.entity.Cart;
import com.ekingwin.bas.cloud.cart.dto.CartDto;
import com.ekingwin.bas.cloud.cart.dto.IdleGoodsListDto;
import com.ekingwin.bas.cloud.dto.IpCarSearchDto;
import com.ekingwin.bas.cloud.dto.IpCarUpdateDto;
import com.ekingwin.bas.cloud.dto.IpCartDeleteDto;
import com.ekingwin.bas.cloud.dto.IpcCartDto;
import com.ekingwin.bas.cloud.entity.IpcCart;
import com.ekingwin.bas.cloud.vo.IpCarDetailVo;
import com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigInteger;
import java.util.List;

@Repository
public interface IpcCartMapper {
    int deleteByPrimaryKey(Integer id);//1

    int insert(IpcCart record);//2

    int insertSelective(IpcCart record);//3

    IpcCart selectByPrimaryKey(Long id);//4

    int updateByPrimaryKeySelective(IpcCart record);//5

    int updateByPrimaryKey(IpcCart record);//6

    /**
     * 批量删除购物车
     * @param ids
     * @return
     */
    int deleteByCarIds(@Param("carIds") String ids);

    /**
    *
    * @Param:  * @param carIds
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/11/6 20:09
    */
    int selectCarIds(@Param("carIds") String carIds);//8


    /**
     * 获取购物车的数量
     * @param ipCarSearchDto
     * @return
     */
    int getCarCount(IpCarSearchDto ipCarSearchDto);//9

    /**
     * 获取外部用户购物车的数量
     * @param ipCarSearchDto
     * @return
     */
    int getCarOutCount(IpCarSearchDto ipCarSearchDto);//10


    /**
     * 获取商品的状态
     * @param ipcCartDto
     * @return
     */
    Integer getGoodsStatus(IpcCartDto ipcCartDto);//11

    Integer getGoodsStatusById(String goodsid);//12
    /**
     *查询购物车
     * @param ipcCartDto
     * @return
     */
    List<IpcCart> selectCarGoods(IpcCartDto ipcCartDto);//13

    /**
     * 供应商查询购物车
     * @param ipcCartDto
     * @return
     */
    List<IpcCart> selectCarGoodsBySuppliers(IpcCartDto ipcCartDto);//14

    /**
     * 外部用户查询购物车
     * @param ipcCartDto
     * @return
     */
    List<IpcCart> selectOutCarGoods(IpcCartDto ipcCartDto);//15


    /**
     * 查询购物车列表
     * @param ipCarSearchDto1
     * @return
     */
    List<IpCarDetailVo>  getSupplierList(IpCarSearchDto ipCarSearchDto1);//16

    /**
     *
     * 查询购物车列表
     * @param ipCarSearchDto1
     * @return
     */
    List<IpCarDetailVo>  getOutSupplierList(IpCarSearchDto ipCarSearchDto1);//17


    /**
     * 清空购物车
     * @param ipCartDeleteDto
     * @return
     */
    int deleteCar(IpCartDeleteDto ipCartDeleteDto);//18


    /**
     * 修改购物车商品
     * @param ipCarUpdateDto
     * @return
     */
    int updateCar(IpCarUpdateDto ipCarUpdateDto);//19

    /**
    * 查询商品的库存
    * @Param:  * @param id
    * @return: com.ekingwin.bas.cloud.vo.IpOrderGoodsDetailVo
    * @Author: zhangjie
    * @Date: 2019/10/23 11:37
    */
    IpOrderGoodsDetailVo getGoodsStock(String id);//20

    IpOrderGoodsDetailVo getGoodsStockAttrid(@Param(value = "id")String id,@Param(value = "attrid")String attrid);//21

    /**
     * 查询当前的goodsid对应的物料编码
     * @param goodsid
     * @return
     */
    String querymdmcode(String goodsid);


    /**
     * 查询出物料编码对应的闲置商品
     * @param mdmcode
     * @return
     */
    List<IdleGoodsListDto> queryidlegoods(String mdmcode);

    /**
     * 查询出物料编码对应的非闲置商品
     * @param mdmcode
     * @return
     */
    List<IdleGoodsListDto> queryidlegood(String mdmcode);


    List<IpcCart> getGoodsid(@Param("ids") String ids);

    void updateGoodsStock(@Param("goodsid") String goodsid,@Param("stock") String stock);


    /**
     * 查询当前是闲置商品还是非闲置商品
     * @param goodsid
     * @return
     */
    String queryidlegoodss(String goodsid);

    /**
     * 查询当前商品库存量
     * @return
     */
    String querystock(String goodsid);

    /**
     * 购物车页面数量的增减
     * @param goodsListDto
     */
    void UpdatecartAddCount(IdleGoodsListDto goodsListDto);
}