package com.ekingwin.bas.cloud.dao;

import com.ekingwin.bas.cloud.dto.IpOrderGoodsStatusDto;
import com.ekingwin.bas.cloud.dto.IpOrderReceiveGoodDto;
import com.ekingwin.bas.cloud.dto.OrderPaymentResultDto;
import com.ekingwin.bas.cloud.entity.IpcOrderAllgoods;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.List;

@Repository
public interface IpcOrderAllgoodsMapper {
    int deleteByPrimaryKey(Long id);


    int insertSelective(IpcOrderAllgoods record);

    IpcOrderAllgoods selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(IpcOrderAllgoods record);


    /**
     * 根据订单ID删除信息
     * @param deleteByOrderid
     * @return
     */
    int deleteByOrderid(Long deleteByOrderid);


    /**
     * 修改已发货
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);


    /**
     * 修改已收货
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsStatus1(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);

    /**
     * 修改发货数量和状态
     * @param ipOrderGoodsStatusDto
     * @return
     */
    int updateGoodsDeliverCount(IpOrderGoodsStatusDto ipOrderGoodsStatusDto);

    /**
     * 更新商品状态
     * @param instid
     * @return
     */
    int updateStatusByInstid(@Param(value = "instid") String instid, @Param(value = "status") String status);


    /**
     * 更新商品状态
     * @return
     */
    int updateStatusByOrderId(@Param(value = "orderId") Long orderId, @Param(value = "status") String status);


    /**
     * 获取商品的收货数量
     * @param orderGoodsId
     * @return
     */
    BigDecimal getReceiverGoods(String orderGoodsId);
    /**
     * 获取商品的发货数量
     * @param orderGoodsId
     * @return
     */
    BigDecimal getDeliverGoods(String orderGoodsId);


    /**
    * 修改商品的数据
    * @Param:  * @param goods
    * @return: int
    */
    int updateGoodsReceiverList(@Param(value ="list") List<IpOrderReceiveGoodDto> goods);


    /**
    * 订单支付成功之后更改状态
    * @Param:  * @param orderPaymentResultDto
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/24 18:53
    */
    int updateStatusByOrderNum(OrderPaymentResultDto orderPaymentResultDto);


    /**
    * 扣减修改库存
    * @Param:  * @param goodsNum
     * @param goodsid
    * @return: int
    * @Author: zhangjie
    * @Date: 2019/10/28 13:41
    */
    int updateGoodsStock(@Param(value = "goodsAmount") String goodsAmount,
                         @Param(value = "goodsid") String goodsid);
}